require 'spec_helper'

describe 'collectd::plugin::swap', :type => :class do

  context ':ensure => present, default params' do
    let :facts do
      {:osfamily => 'RedHat'}
    end
    it 'Will create /etc/collectd.d/10-swap.conf' do
      should contain_file('swap.load').with({
        :ensure  => 'present',
        :path    => '/etc/collectd.d/10-swap.conf',
        :content => /\#\ Generated by Puppet\nLoadPlugin swap\n\n<Plugin swap>\n  ReportByDevice false\n<\/Plugin>\n/,
      })
    end
  end

  context ':ensure => present, specific params, collectd version 5.0' do
    let :facts do
      { :osfamily         => 'Redhat',
        :collectd_version => '5.0'
      }
    end

    it 'Will create /etc/collectd.d/10-swap.conf for collectd < 5.2' do
      should contain_file('swap.load').with({
        :ensure  => 'present',
        :path    => '/etc/collectd.d/10-swap.conf',
        :content => "# Generated by Puppet\n<LoadPlugin swap>\n  Globals false\n</LoadPlugin>\n\n<Plugin swap>\n  ReportByDevice false\n</Plugin>\n\n",
      })
    end
  end

  context ':ensure => present, specific params, collectd version 5.2.0' do
    let :facts do
      { :osfamily         => 'Redhat',
        :collectd_version => '5.2.0'
      }
    end

    it 'Will create /etc/collectd.d/10-swap.conf for collectd >= 5.2' do
      should contain_file('swap.load').with({
        :ensure  => 'present',
        :path    => '/etc/collectd.d/10-swap.conf',
        :content => "# Generated by Puppet\n<LoadPlugin swap>\n  Globals false\n</LoadPlugin>\n\n<Plugin swap>\n  ReportByDevice false\n  ReportBytes true\n</Plugin>\n\n",
      })
    end
  end

  context ':ensure => present, specific params, collectd version 5.5.0' do
    let :facts do
      { :osfamily         => 'Redhat',
        :collectd_version => '5.5.0'
      }
    end

    it 'Will create /etc/collectd.d/10-swap.conf for collectd >= 5.5' do
      should contain_file('swap.load').with({
        :ensure  => 'present',
        :path    => '/etc/collectd.d/10-swap.conf',
        :content => "# Generated by Puppet\n<LoadPlugin swap>\n  Globals false\n</LoadPlugin>\n\n<Plugin swap>\n  ReportByDevice false\n  ReportBytes true\n  ValuesAbsolute = true\n  ValuesPercentage = false\n</Plugin>\n\n",
      })
    end
  end

  context ':ensure => absent' do
    let :facts do
      {:osfamily => 'RedHat'}
    end
    let :params do
      {:ensure => 'absent'}
    end

    it 'Will not create /etc/collectd.d/10-swap.conf' do
      should contain_file('swap.load').with({
        :ensure => 'absent',
        :path   => '/etc/collectd.d/10-swap.conf',
      })
    end
  end
end

