"""removing redundant fields from order

Revision ID: 254495565185
Revises: 2843d6469f25
Create Date: 2014-09-16 12:09:23.716390

"""

# revision identifiers, used by Alembic.
revision = '254495565185'
down_revision = '2843d6469f25'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('orders', 'secret_mode')
    op.drop_column('orders', 'secret_algorithm')
    op.drop_column('orders', 'secret_bit_length')
    op.drop_column('orders', 'secret_expiration')
    op.drop_column('orders', 'secret_payload_content_type')
    op.drop_column('orders', 'secret_name')
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.add_column('orders', sa.Column('secret_name', mysql.VARCHAR(length=255), nullable=True))
    op.add_column('orders', sa.Column('secret_payload_content_type', mysql.VARCHAR(length=255), nullable=False))
    op.add_column('orders', sa.Column('secret_expiration', mysql.DATETIME(), nullable=True))
    op.add_column('orders', sa.Column('secret_bit_length', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True))
    op.add_column('orders', sa.Column('secret_algorithm', mysql.VARCHAR(length=255), nullable=True))
    op.add_column('orders', sa.Column('secret_mode', mysql.VARCHAR(length=255), nullable=True))
    ### end Alembic commands ###
