# vim: tabstop=4 shiftwidth=4 softtabstop=4
#
# Copyright 2012 New Dream Network, LLC (DreamHost)
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
#
# @author Mark McClain (DreamHost)

The migrations in the alembic/versions contain the changes needed to migrate
from older billingstack releases to newer versions. A migration occurs by executing
a script that details the changes needed to upgrade/downgrade the database. The
migration scripts are ordered so that multiple scripts can run sequentially to
update the database. The scripts are executed by billingstack's migration wrapper
which uses the Alembic library to manage the migration.  billingstack supports
migration from Folsom or later.


If you are a deployer or developer and want to migrate from Folsom to Grizzly
or later you must first add version tracking to the database:

$ billingstack-db-manage -config-file /path/to/quantum.conf \
 --config-file /path/to/plugin/config.ini stamp folsom

You can then upgrade to the latest database version via:
$ billingstack-db-manage --config-file /path/to/quantum.conf \
 --config-file /path/to/plugin/config.ini upgrade head

To check the current database version:
$ billingstack-db-manage --config-file /path/to/quantum.conf \
 --config-file /path/to/plugin/config.ini current

To create a script to run the migration offline:
$ billingstack-db-manage --config-file /path/to/quantum.conf \
 --config-file /path/to/plugin/config.ini upgrade head --sql

To run the offline migration between specific migration versions:
$ billingstack-db-manage --config-file /path/to/quantum.conf \
--config-file /path/to/plugin/config.ini upgrade \
<start version>:<end version> --sql

Upgrade the database incrementally:
$ billingstack-db-manage --config-file /path/to/quantum.conf \
--config-file /path/to/plugin/config.ini upgrade --delta <# of revs>

Downgrade the database by a certain number of revisions:
$ billingstack-db-manage --config-file /path/to/quantum.conf \
--config-file /path/to/plugin/config.ini downgrade --delta <# of revs>


DEVELOPERS:
A database migration script is required when you submit a change to billingstack
that alters the database model definition.  The migration script is a special
python file that includes code to update/downgrade the database to match the
changes in the model definition. Alembic will execute these scripts in order to
provide a linear migration path between revision. The billingstack-db-manage command
can be used to generate migration template for you to complete.  The operations
in the template are those supported by the Alembic migration library.

$ billingstack-db-manage --config-file /path/to/quantum.conf \
--config-file /path/to/plugin/config.ini revision \
-m "description of revision" \
--autogenerate

This generates a prepopulated template with the changes needed to match the
database state with the models.  You should inspect the autogenerated template
to ensure that the proper models have been altered.

In rare circumstances, you may want to start with an empty migration template
and manually author the changes necessary for an upgrade/downgrade.  You can
create a blank file via:

$ billingstack-db-manage --config-file /path/to/quantum.conf \
--config-file /path/to/plugin/config.ini revision \
-m "description of revision"

The migration timeline should remain linear so that there is a clear path when
upgrading/downgrading.  To verify that the timeline does branch, you can run
this command:
$ billingstack-db-manage --config-file /path/to/quantum.conf \
--config-file /path/to/plugin/config.ini check_migration

If the migration path does branch, you can find the branch point via:
$ billingstack-db-manage --config-file /path/to/quantum.conf \
--config-file /path/to/plugin/config.ini history
