/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.MojoExecutionException;

public class FileUtils {
    public static void addDirectory(ZipOutputStream zout, File fileSource) {
        int fileSourceNameLength = fileSource.toString().length() + 1;
        FileUtils.addDirectory(zout, fileSource, fileSourceNameLength);
    }

    private static void addDirectory(ZipOutputStream zout, File fileSource, int fileSourceNameLength) {
        File[] files = fileSource.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileUtils.addDirectory(zout, files[i], fileSourceNameLength);
                continue;
            }
            try {
                int length;
                byte[] buffer = new byte[1024];
                FileInputStream fin = new FileInputStream(files[i]);
                String parentPath = "";
                if (fileSource.toString().length() > fileSourceNameLength) {
                    parentPath = fileSource.toString().substring(fileSourceNameLength) + "/";
                }
                zout.putNextEntry(new ZipEntry(parentPath + files[i].getName()));
                while ((length = fin.read(buffer)) > 0) {
                    zout.write(buffer, 0, length);
                }
                zout.closeEntry();
                fin.close();
                continue;
            }
            catch (IOException ioe) {
                System.out.println("IOException :" + ioe);
            }
        }
    }

    public static void mkdir(File directory) throws MojoExecutionException {
        try {
            directory.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error Creating Directory " + e);
        }
    }

    public static void extractJaredDirectory(String directory, Class<?> jarSrc, File dest) throws MojoExecutionException {
        try {
            File jar;
            try {
                jar = new File(jarSrc.getProtectionDomain().getCodeSource().getLocation().toURI());
            }
            catch (URISyntaxException e) {
                jar = new File(jarSrc.getProtectionDomain().getCodeSource().getLocation().getFile());
            }
            ZipFile zf = new ZipFile(jar);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                int read;
                ZipEntry ze = entries.nextElement();
                if (!ze.getName().startsWith(directory)) continue;
                if (ze.isDirectory()) {
                    File newDir = new File(dest, ze.getName());
                    newDir.mkdirs();
                    continue;
                }
                File outFile = new File(dest, ze.getName());
                BufferedInputStream in = new BufferedInputStream(zf.getInputStream(ze));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
                while ((read = in.read()) != -1) {
                    out.write(read);
                }
                in.close();
                out.close();
            }
            zf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error while extracting jar files", e);
        }
    }
}

