/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs;

import com.rackspace.cloud.api.docs.pipeline.CalabashPipelineBuilder;
import com.rackspace.cloud.api.docs.pipeline.MavenXProcMessageListener;
import com.rackspace.cloud.api.docs.pipeline.Pipeline;
import com.rackspace.cloud.api.docs.pipeline.PipelineInput;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.xml.sax.InputSource;

public class CalabashHelper {
    private static Source run(Log log, String pipelineURI, final InputSource inputSource, Map<String, Object> map) throws FileNotFoundException {
        MavenXProcMessageListener messageListener = log != null ? new MavenXProcMessageListener(log) : null;
        Pipeline pipeline = new CalabashPipelineBuilder(false, true, messageListener).build(pipelineURI);
        StringBuffer strBuff = new StringBuffer("<c:param-set xmlns:c=\"http://www.w3.org/ns/xproc-step\">");
        strBuff.append("");
        if (null != map) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String rawValue;
                if (entry.getValue() instanceof File) {
                    rawValue = ((File)entry.getValue()).toURI().toString();
                } else if (entry.getValue() instanceof URI || entry.getValue() instanceof String) {
                    rawValue = entry.getValue().toString();
                } else if (entry.getValue() instanceof URL) {
                    rawValue = ((URL)entry.getValue()).toExternalForm();
                } else {
                    if (entry.getValue() == null) continue;
                    throw new UnsupportedOperationException(String.format("The map cannot contain values of type %s.", entry.getValue().getClass()));
                }
                strBuff.append("<c:param name=\"").append(CalabashHelper.escapeXmlAttribute(entry.getKey())).append("\" namespace=\"\" value=\"").append(CalabashHelper.escapeXmlAttribute(rawValue)).append("\"/>");
            }
        }
        strBuff.append("</c:param-set>");
        String params = strBuff.toString();
        final ByteArrayInputStream paramsStream = new ByteArrayInputStream(params.getBytes());
        ArrayList pipelineInputs = new ArrayList<PipelineInput<?>>(){
            {
                this.add(PipelineInput.port("source", inputSource));
                this.add(PipelineInput.port("parameters", new InputSource(paramsStream)));
            }
        };
        pipeline.run(pipelineInputs);
        List<Source> sources = pipeline.getResultPort("result");
        return sources.get(0);
    }

    private static String escapeXmlAttribute(String value) {
        if (value == null) {
            return "";
        }
        return value.replace("&", "&amp;").replace("\"", "&quot;").replace("'", "&apos;").replace("%", "&#37;");
    }

    public static Source createSource(Log log, Source source, String pipelineURI, Map<String, Object> map) throws MojoExecutionException {
        try {
            if (!(source instanceof SAXSource)) {
                throw new MojoExecutionException("Expecting a SAXSource");
            }
            SAXSource saxSource = (SAXSource)source;
            return CalabashHelper.run(log, pipelineURI, saxSource.getInputSource(), map);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Failed to find source.", (Exception)e);
        }
    }
}

