/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs.pipeline;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.util.URIUtils;
import java.net.URI;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import org.apache.maven.plugin.logging.Log;

public class MavenXProcMessageListener
implements XProcMessageListener {
    private final Log log;

    public MavenXProcMessageListener(Log log) {
        this.log = log;
    }

    public void error(XProcRunnable step, XdmNode node, String message, QName code) {
        this.log.error((CharSequence)this.message(step, node, message, code));
    }

    public void error(Throwable exception) {
        this.log.error((CharSequence)(this.exceptionMessage(exception) + exception.getMessage()));
    }

    private String exceptionMessage(Throwable exception) {
        StructuredQName qCode = null;
        SourceLocator loc = null;
        String message = "";
        if (exception instanceof XPathException) {
            qCode = ((XPathException)exception).getErrorCodeQName();
        }
        if (exception instanceof TransformerException) {
            TransformerException tx = (TransformerException)exception;
            if (qCode == null && tx.getException() instanceof XPathException) {
                qCode = ((XPathException)tx.getException()).getErrorCodeQName();
            }
            if (tx.getLocator() != null) {
                loc = tx.getLocator();
                boolean done = false;
                while (!done && loc == null) {
                    if (tx.getException() instanceof TransformerException) {
                        tx = (TransformerException)tx.getException();
                        loc = tx.getLocator();
                        continue;
                    }
                    if (exception.getCause() instanceof TransformerException) {
                        tx = (TransformerException)exception.getCause();
                        loc = tx.getLocator();
                        continue;
                    }
                    done = true;
                }
            }
        }
        if (exception instanceof XProcException) {
            XProcException err = (XProcException)exception;
            loc = err.getLocator();
            if (err.getErrorCode() != null) {
                QName n = err.getErrorCode();
                qCode = new StructuredQName(n.getPrefix(), n.getNamespaceURI(), n.getLocalName());
            }
            if (err.getStep() != null) {
                message = message + err.getStep() + ":";
            }
        }
        if (loc != null) {
            if (loc.getSystemId() != null && !"".equals(loc.getSystemId())) {
                message = message + loc.getSystemId() + ":";
            }
            if (loc.getLineNumber() != -1) {
                message = message + loc.getLineNumber() + ":";
            }
            if (loc.getColumnNumber() != -1) {
                message = message + loc.getColumnNumber() + ":";
            }
        }
        if (qCode != null) {
            message = message + qCode.getDisplayName() + ":";
        }
        return message;
    }

    public void warning(XProcRunnable step, XdmNode node, String message) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((CharSequence)this.message(step, node, message));
        }
    }

    public void warning(Throwable exception) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((CharSequence)(this.exceptionMessage(exception) + exception.getMessage()));
        }
    }

    public void info(XProcRunnable step, XdmNode node, String message) {
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)this.message(step, node, message));
        }
    }

    public void fine(XProcRunnable step, XdmNode node, String message) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)this.message(step, node, message));
        }
    }

    public void finer(XProcRunnable step, XdmNode node, String message) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)this.message(step, node, message));
        }
    }

    public void finest(XProcRunnable step, XdmNode node, String message) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)this.message(step, node, message));
        }
    }

    private String message(XProcRunnable step, XdmNode node, String message) {
        return this.message(step, node, message, null);
    }

    private String message(XProcRunnable step, XdmNode node, String message, QName code) {
        String prefix = "";
        if (node != null) {
            URI cwd = URIUtils.cwdAsURI();
            String systemId = cwd.relativize(node.getBaseURI()).toASCIIString();
            int line = node.getLineNumber();
            int col = node.getColumnNumber();
            if (systemId != null && !"".equals(systemId)) {
                prefix = prefix + systemId + ":";
            }
            if (line != -1) {
                prefix = prefix + line + ":";
            }
            if (col != -1) {
                prefix = prefix + col + ":";
            }
        }
        return prefix + message;
    }
}

