/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject;

import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.CapabilityControl;
import com.google.gerrit.server.config.AllProjectsNameProvider;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.googlesource.gerrit.plugins.deleteproject.CannotDeleteProjectException;
import com.googlesource.gerrit.plugins.deleteproject.cache.CacheDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.database.DatabaseDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.fs.FilesystemDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.projectconfig.ProjectConfigDeleteHandler;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Config;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@CommandMetaData(name="delete", description="Delete specific project")
public final class DeleteCommand
extends SshCommand {
    @Argument(index=0, required=true, metaVar="NAME", usage="project to delete")
    private ProjectControl projectControl;
    @Option(name="--yes-really-delete", usage="confirmation to delete the project")
    private boolean yesReallyDelete;
    @Option(name="--force", usage="delete the project even if it has open changes")
    private boolean force = false;
    @Option(name="--preserve-git-repository", usage="don't delete git repository directory")
    private boolean preserveGitRepository = false;
    private final CacheDeleteHandler cacheDeleteHandler;
    private final DatabaseDeleteHandler databaseDeleteHandler;
    private final FilesystemDeleteHandler filesystemDeleteHandler;
    private final ProjectConfigDeleteHandler pcHandler;
    private final Provider<CurrentUser> userProvider;
    private final String pluginName;

    @Inject
    protected DeleteCommand(@GerritServerConfig Config cfg, AllProjectsNameProvider allProjectsNameProvider, DatabaseDeleteHandler databaseDeleteHandler, FilesystemDeleteHandler filesystemDeleteHandler, CacheDeleteHandler cacheDeleteHandler, ProjectConfigDeleteHandler pcHandler, Provider<CurrentUser> userProvider, @PluginName String pluginName) {
        this.databaseDeleteHandler = databaseDeleteHandler;
        this.filesystemDeleteHandler = filesystemDeleteHandler;
        this.cacheDeleteHandler = cacheDeleteHandler;
        this.pcHandler = pcHandler;
        this.userProvider = userProvider;
        this.pluginName = pluginName;
    }

    public void run() throws BaseCommand.Failure {
        CapabilityControl ctl = ((CurrentUser)this.userProvider.get()).getCapabilities();
        if (!(ctl.canAdministrateServer() || ctl.canPerform(this.pluginName + "-" + "deleteProject") || ctl.canPerform(this.pluginName + "-" + "deleteOwnProject") && this.projectControl.isOwner())) {
            throw new BaseCommand.UnloggedFailure("not allowed to delete project");
        }
        Project project = this.projectControl.getProject();
        String projectName = project.getName();
        try {
            this.pcHandler.assertCanDelete(new ProjectResource(this.projectControl));
        }
        catch (CannotDeleteProjectException e) {
            throw new BaseCommand.UnloggedFailure(e.getMessage());
        }
        try {
            this.databaseDeleteHandler.assertCanDelete(project);
        }
        catch (CannotDeleteProjectException e) {
            throw new BaseCommand.UnloggedFailure("Cannot delete project " + projectName + ": " + e.getMessage());
        }
        catch (OrmException e) {
            this.die(e);
        }
        if (!this.yesReallyDelete) {
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append("Really delete ");
            msgBuilder.append(projectName);
            msgBuilder.append("?\n");
            msgBuilder.append("This is an operation which permanently deletes ");
            msgBuilder.append("data. This cannot be undone!\n");
            msgBuilder.append("If you are sure you wish to delete this project, ");
            msgBuilder.append("re-run\n");
            msgBuilder.append("with the --yes-really-delete flag.\n");
            throw new BaseCommand.UnloggedFailure(msgBuilder.toString());
        }
        if (!this.force) {
            Collection<String> warnings = null;
            try {
                warnings = this.databaseDeleteHandler.getWarnings(project);
            }
            catch (OrmException e) {
                this.die(e);
            }
            if (warnings != null && !warnings.isEmpty()) {
                StringBuilder msgBuilder = new StringBuilder();
                msgBuilder.append("There are warnings against deleting ");
                msgBuilder.append(projectName);
                msgBuilder.append(":\n");
                for (String warning : warnings) {
                    msgBuilder.append(" * ");
                    msgBuilder.append(warning);
                    msgBuilder.append("\n");
                }
                msgBuilder.append("To really delete ");
                msgBuilder.append(projectName);
                msgBuilder.append(", re-run with the --force flag.");
                throw new BaseCommand.UnloggedFailure(msgBuilder.toString());
            }
        }
        try {
            this.databaseDeleteHandler.delete(project);
            this.filesystemDeleteHandler.delete(project, this.preserveGitRepository);
            this.cacheDeleteHandler.delete(project);
        }
        catch (OrmException e) {
            this.die(e);
        }
        catch (RepositoryNotFoundException e) {
            this.die(e);
        }
        catch (IOException e) {
            this.die(e);
        }
    }
}

