/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject.database;

import com.google.common.collect.Lists;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.deleteproject.CannotDeleteProjectException;
import com.googlesource.gerrit.plugins.deleteproject.database.DatabaseDeleteHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class Schema73DatabaseDeleteHandler
implements DatabaseDeleteHandler {
    private final ReviewDb db;

    @Inject
    public Schema73DatabaseDeleteHandler(ReviewDb db) {
        this.db = db;
    }

    @Override
    public void assertCanDelete(Project project) throws CannotDeleteProjectException, OrmException {
        Connection conn = ((JdbcSchema)this.db).getConnection();
        String projectName = project.getName();
        try {
            if (conn.createStatement().executeQuery("SELECT * FROM submodule_subscriptions WHERE super_project_project_name = '" + projectName + "'").first()) {
                throw new CannotDeleteProjectException("Project has subscribed submodules.");
            }
            if (conn.createStatement().executeQuery("SELECT * FROM submodule_subscriptions WHERE submodule_project_name = '" + projectName + "'").first()) {
                throw new CannotDeleteProjectException("Project is subscribed by other projects.");
            }
        }
        catch (SQLException e) {
            throw new OrmException((Throwable)e);
        }
    }

    @Override
    public Collection<String> getWarnings(Project project) throws OrmException {
        ArrayList ret = Lists.newArrayList();
        ResultSet openChanges = this.db.changes().byProjectOpenAll(project.getNameKey());
        if (openChanges.iterator().hasNext()) {
            ret.add(project.getName() + " has open changes");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Project project) throws OrmException {
        Connection conn = ((JdbcSchema)this.db).getConnection();
        try {
            conn.setAutoCommit(false);
            try {
                this.atomicDelete(project);
                conn.commit();
            }
            finally {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                throw new OrmException((Throwable)ex);
            }
            throw new OrmException((Throwable)e);
        }
    }

    public void atomicDelete(Project project) throws OrmException {
        ResultSet changes = null;
        changes = this.db.changes().byProject(project.getNameKey());
        this.deleteChanges((ResultSet<Change>)changes);
        this.db.accountProjectWatches().delete((Iterable)this.db.accountProjectWatches().byProject(project.getNameKey()));
    }

    private final void deleteChanges(ResultSet<Change> changes) throws OrmException {
        for (Change change : changes) {
            Change.Id id = change.getId();
            ResultSet patchSets = null;
            patchSets = this.db.patchSets().byChange(id);
            if (patchSets != null) {
                this.deleteFromPatchSets((ResultSet<PatchSet>)patchSets);
            }
            this.db.patchComments().delete((Iterable)this.db.patchComments().byChange(id));
            this.db.patchSetApprovals().delete((Iterable)this.db.patchSetApprovals().byChange(id));
            this.db.changeMessages().delete((Iterable)this.db.changeMessages().byChange(id));
            this.db.starredChanges().delete((Iterable)this.db.starredChanges().byChange(id));
            this.db.changes().delete(Collections.singleton(change));
        }
    }

    private final void deleteFromPatchSets(ResultSet<PatchSet> patchSets) throws OrmException {
        for (PatchSet patchSet : patchSets) {
            this.db.patchSetAncestors().delete((Iterable)this.db.patchSetAncestors().byPatchSet(patchSet.getId()));
            this.db.accountPatchReviews().delete((Iterable)this.db.accountPatchReviews().byPatchSet(patchSet.getId()));
            this.db.patchSets().delete(Collections.singleton(patchSet));
        }
    }
}

