/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject.database;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.deleteproject.CannotDeleteProjectException;
import com.googlesource.gerrit.plugins.deleteproject.database.Schema73DatabaseDeleteHandler;

public class Schema77DatabaseDeleteHandler
extends Schema73DatabaseDeleteHandler {
    private final ReviewDb db;

    @Inject
    public Schema77DatabaseDeleteHandler(ReviewDb db) {
        super(db);
        this.db = db;
    }

    @Override
    public void assertCanDelete(Project project) throws CannotDeleteProjectException, OrmException {
        if (this.db.submoduleSubscriptions().bySubmoduleProject(project.getNameKey()).iterator().hasNext()) {
            throw new CannotDeleteProjectException("Project is subscribed by other projects.");
        }
    }

    @Override
    public void atomicDelete(Project project) throws OrmException {
        super.atomicDelete(project);
        this.db.submoduleSubscriptions().delete((Iterable)this.db.submoduleSubscriptions().bySuperProjectProject(project.getNameKey()));
    }
}

