/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject;

import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.AllProjectsNameProvider;
import com.google.gerrit.server.config.PluginConfigFactory;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.googlesource.gerrit.plugins.deleteproject.DeleteLog;
import com.googlesource.gerrit.plugins.deleteproject.DeleteProject;
import com.googlesource.gerrit.plugins.deleteproject.HideProject;
import com.googlesource.gerrit.plugins.deleteproject.cache.CacheDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.database.DatabaseDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.fs.FilesystemDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.projectconfig.ProjectConfigDeleteHandler;

public class DeleteAction
extends DeleteProject
implements UiAction<ProjectResource> {
    @Inject
    DeleteAction(AllProjectsNameProvider allProjectsNameProvider, DatabaseDeleteHandler dbHandler, FilesystemDeleteHandler fsHandler, CacheDeleteHandler cacheHandler, ProjectConfigDeleteHandler pcHandler, Provider<CurrentUser> userProvider, @PluginName String pluginName, DeleteLog deleteLog, PluginConfigFactory cfgFactory, HideProject hideProject) {
        super(allProjectsNameProvider, dbHandler, fsHandler, cacheHandler, pcHandler, userProvider, pluginName, deleteLog, cfgFactory, hideProject);
    }

    public UiAction.Description getDescription(ProjectResource rsrc) {
        return new UiAction.Description().setLabel("Delete...").setTitle(this.isAllProjects(rsrc) ? String.format("No deletion of %s project", this.allProjectsName) : String.format("Delete project %s", rsrc.getName())).setEnabled(!this.isAllProjects(rsrc)).setVisible(this.canDelete(rsrc));
    }

    private boolean isAllProjects(ProjectResource rsrc) {
        return rsrc.getControl().getProject().getNameKey().equals((Object)this.allProjectsName);
    }
}

