/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject;

import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.errors.ProjectCreationFailedException;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.extensions.client.ProjectState;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.PluginConfigFactory;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.CreateProject;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;

@Singleton
class HideProject {
    private static String DEFAULT_PARENT_FOR_DELETED_PROJECTS = "Deleted-Projects";
    private final MetaDataUpdate.Server metaDataUpdateFactory;
    private final ProjectCache projectCache;
    private final CreateProject.Factory createProjectFactory;
    private final PluginConfigFactory cfgFactory;
    private final String pluginName;

    @Inject
    HideProject(MetaDataUpdate.Server metaDataUpdateFactory, ProjectCache projectCache, CreateProject.Factory createProjectFactory, PluginConfigFactory cfgFactory, @PluginName String pluginName) {
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.projectCache = projectCache;
        this.createProjectFactory = createProjectFactory;
        this.cfgFactory = cfgFactory;
        this.pluginName = pluginName;
    }

    public void apply(ProjectResource rsrc) throws ResourceNotFoundException, ResourceConflictException, IOException {
        try {
            MetaDataUpdate md = this.metaDataUpdateFactory.create(rsrc.getNameKey());
            ProjectConfig projectConfig = ProjectConfig.read((MetaDataUpdate)md);
            Project p = projectConfig.getProject();
            p.setState(ProjectState.HIDDEN);
            for (AccessSection as : projectConfig.getAccessSections()) {
                projectConfig.remove(as);
            }
            String parentForDeletedProjects = this.cfgFactory.getFromGerritConfig(this.pluginName).getString("parentForDeletedProjects", DEFAULT_PARENT_FOR_DELETED_PROJECTS);
            this.createProjectIfMissing(parentForDeletedProjects);
            p.setParentName(parentForDeletedProjects);
            md.setMessage("Hide project\n");
            projectConfig.commit(md);
            this.projectCache.evict(projectConfig.getProject());
        }
        catch (RepositoryNotFoundException e) {
            throw new ResourceNotFoundException();
        }
        catch (ConfigInvalidException e) {
            throw new ResourceConflictException(e.getMessage());
        }
    }

    private void createProjectIfMissing(String projectName) throws ResourceConflictException, IOException {
        if (this.projectCache.get(new Project.NameKey(projectName)) == null) {
            try {
                this.createProjectFactory.create(projectName).apply(TopLevelResource.INSTANCE, null);
            }
            catch (ProjectCreationFailedException | BadRequestException | ResourceNotFoundException | UnprocessableEntityException e) {
                throw new ResourceConflictException(String.format("Failed to create project %s", projectName));
            }
        }
    }
}

