/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject.projectconfig;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AllProjectsNameProvider;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.project.ListChildProjects;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.googlesource.gerrit.plugins.deleteproject.CannotDeleteProjectException;
import java.util.List;

public class ProjectConfigDeleteHandler {
    protected final AllProjectsName allProjectsName;
    private final SitePaths site;
    private final Provider<ListChildProjects> listChildProjectsProvider;

    @Inject
    public ProjectConfigDeleteHandler(SitePaths site, AllProjectsNameProvider allProjectsNameProvider, Provider<ListChildProjects> listChildProjectsProvider) {
        this.site = site;
        this.allProjectsName = allProjectsNameProvider.get();
        this.listChildProjectsProvider = listChildProjectsProvider;
    }

    public void assertCanDelete(ProjectResource rsrc) throws CannotDeleteProjectException {
        this.assertIsNotAllProjects(rsrc);
        this.assertHasNoChildProjects(rsrc);
    }

    private void assertIsNotAllProjects(ProjectResource rsrc) throws CannotDeleteProjectException {
        Project project = rsrc.getControl().getProject();
        if (project.getNameKey().equals((Object)this.allProjectsName)) {
            throw new CannotDeleteProjectException("Perhaps you meant to rm -fR " + this.site.site_path);
        }
    }

    private void assertHasNoChildProjects(ProjectResource rsrc) throws CannotDeleteProjectException {
        List children = ((ListChildProjects)this.listChildProjectsProvider.get()).apply(rsrc);
        if (!children.isEmpty()) {
            String childrenString = Joiner.on((String)", ").join(Iterables.transform((Iterable)children, (Function)new Function<ProjectInfo, String>(){

                public String apply(ProjectInfo info) {
                    return info.name;
                }
            }));
            throw new CannotDeleteProjectException("Cannot delete project because it has children: " + childrenString);
        }
    }
}

