/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gerrit.audit.AuditEvent;
import com.google.gerrit.audit.AuditService;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.systemstatus.ServerInformation;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.OutputFormat;
import com.google.gerrit.server.util.PluginLogFile;
import com.google.gerrit.server.util.SystemLog;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.googlesource.gerrit.plugins.deleteproject.DeleteLogLayout;
import com.googlesource.gerrit.plugins.deleteproject.DeleteProject;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

@Singleton
class DeleteLog
extends PluginLogFile {
    private static final String DELETE_LOG_NAME = "delete_log";
    private static final Logger log = LogManager.getLogger((String)"delete_log");
    public static final String ACCOUNT_ID = "accountId";
    public static final String USER_NAME = "userName";
    public static final String PROJECT_NAME = "projectName";
    public static final String OPTIONS = "options";
    public static final String ERROR = "error";
    private final AuditService auditService;

    @Inject
    public DeleteLog(SystemLog systemLog, ServerInformation serverInfo, AuditService auditService) {
        super(systemLog, serverInfo, DELETE_LOG_NAME, (Layout)new DeleteLogLayout());
        this.auditService = auditService;
    }

    public void onDelete(IdentifiedUser user, Project.NameKey project, DeleteProject.Input options, Exception ex) {
        long ts = TimeUtil.nowMs();
        LoggingEvent event = new LoggingEvent(Logger.class.getName(), (Category)log, ts, ex == null ? Level.INFO : Level.ERROR, (Object)(ex == null ? "OK" : "FAIL"), Thread.currentThread().getName(), null, null, null, null);
        event.setProperty(ACCOUNT_ID, user.getAccountId().toString());
        event.setProperty(USER_NAME, user.getUserName());
        event.setProperty(PROJECT_NAME, project.get());
        if (options != null) {
            event.setProperty(OPTIONS, OutputFormat.JSON_COMPACT.newGson().toJson((Object)options));
        }
        if (ex != null) {
            event.setProperty(ERROR, ex.toString());
        }
        log.callAppenders(event);
        this.audit(user, ts, project, options, ex);
    }

    private void audit(IdentifiedUser user, long ts, Project.NameKey project, DeleteProject.Input options, Exception ex) {
        HashMultimap params = HashMultimap.create();
        params.put((Object)"class", DeleteLog.class);
        params.put((Object)"project", (Object)project.get());
        if (options != null) {
            params.put((Object)"force", (Object)String.valueOf(options.force));
            params.put((Object)"preserve", (Object)String.valueOf(options.preserve));
        }
        this.auditService.dispatch(new AuditEvent(null, (CurrentUser)user, ex == null ? "ProjectDeletion" : "ProjectDeletionFailure", ts, (Multimap)params, (Object)(ex != null ? ex.toString() : "OK")));
    }
}

