/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.util;

import com.google.common.collect.Sets;
import com.google.gerrit.server.data.AccountAttribute;
import com.google.gerrit.server.data.ApprovalAttribute;
import com.google.gerrit.server.data.ChangeAttribute;
import com.google.gerrit.server.data.PatchSetAttribute;
import com.google.gerrit.server.data.RefUpdateAttribute;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.hooks.workflow.Property;
import java.util.HashSet;
import java.util.Set;

public class PropertyAttributeExtractor {
    private Property.Factory propertyFactory;

    @Inject
    PropertyAttributeExtractor(Property.Factory propertyFactory) {
        this.propertyFactory = propertyFactory;
    }

    public Set<Property> extractFrom(AccountAttribute accountAttribute, String prefix) {
        HashSet properties = Sets.newHashSet();
        if (accountAttribute != null) {
            properties.add(this.propertyFactory.create(prefix + "-email", accountAttribute.email));
            properties.add(this.propertyFactory.create(prefix + "-username", accountAttribute.username));
            properties.add(this.propertyFactory.create(prefix + "-name", accountAttribute.name));
        }
        return properties;
    }

    public Set<Property> extractFrom(ChangeAttribute changeAttribute) {
        HashSet properties = Sets.newHashSet();
        properties.add(this.propertyFactory.create("project", changeAttribute.project));
        properties.add(this.propertyFactory.create("branch", changeAttribute.branch));
        properties.add(this.propertyFactory.create("topic", changeAttribute.topic));
        properties.add(this.propertyFactory.create("subject", changeAttribute.subject));
        properties.add(this.propertyFactory.create("commit-message", changeAttribute.commitMessage));
        properties.add(this.propertyFactory.create("change-id", changeAttribute.id));
        properties.add(this.propertyFactory.create("change-number", changeAttribute.number));
        properties.add(this.propertyFactory.create("change-url", changeAttribute.url));
        String status = null;
        if (changeAttribute.status != null) {
            status = changeAttribute.status.toString();
        }
        properties.add(this.propertyFactory.create("status", status));
        properties.addAll(this.extractFrom(changeAttribute.owner, "owner"));
        return properties;
    }

    public Set<Property> extractFrom(PatchSetAttribute patchSetAttribute) {
        HashSet properties = Sets.newHashSet();
        properties.add(this.propertyFactory.create("revision", patchSetAttribute.revision));
        properties.add(this.propertyFactory.create("patch-set-number", patchSetAttribute.number));
        properties.add(this.propertyFactory.create("ref", patchSetAttribute.ref));
        properties.add(this.propertyFactory.create("created-on", patchSetAttribute.createdOn.toString()));
        properties.add(this.propertyFactory.create("parents", patchSetAttribute.parents.toString()));
        properties.add(this.propertyFactory.create("deletions", Integer.toString(patchSetAttribute.sizeDeletions)));
        properties.add(this.propertyFactory.create("insertions", Integer.toString(patchSetAttribute.sizeInsertions)));
        properties.add(this.propertyFactory.create("is-draft", Boolean.toString(patchSetAttribute.isDraft)));
        properties.addAll(this.extractFrom(patchSetAttribute.uploader, "uploader"));
        properties.addAll(this.extractFrom(patchSetAttribute.author, "author"));
        return properties;
    }

    public Set<Property> extractFrom(RefUpdateAttribute refUpdateAttribute) {
        HashSet properties = Sets.newHashSet();
        properties.add(this.propertyFactory.create("revision", refUpdateAttribute.newRev));
        properties.add(this.propertyFactory.create("revision-old", refUpdateAttribute.oldRev));
        properties.add(this.propertyFactory.create("project", refUpdateAttribute.project));
        properties.add(this.propertyFactory.create("ref", refUpdateAttribute.refName));
        return properties;
    }

    public Set<Property> extractFrom(ApprovalAttribute approvalAttribute) {
        HashSet properties = Sets.newHashSet();
        properties.add(this.propertyFactory.create("approval-" + approvalAttribute.type, approvalAttribute.value));
        return properties;
    }
}

