/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.workflow;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gerrit.common.Nullable;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.googlesource.gerrit.plugins.hooks.workflow.Property;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Condition {
    private final String key;
    private final Set<String> values;
    private final boolean negated;

    @Inject
    public Condition(@Assisted(value="key") String key, @Nullable @Assisted(value="values") String values) {
        HashSet modifyableValues;
        this.key = key;
        boolean modifyableNegated = false;
        if (values == null) {
            modifyableValues = Collections.emptySet();
        } else {
            ArrayList valueList = Lists.newArrayList((Object[])values.split(","));
            if (!valueList.isEmpty() && "!".equals(valueList.get(0))) {
                modifyableNegated = true;
                valueList.remove(0);
            }
            modifyableValues = Sets.newHashSet((Iterable)valueList);
        }
        this.values = Collections.unmodifiableSet(modifyableValues);
        this.negated = modifyableNegated;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isMetBy(Iterable<Property> properties) {
        for (Property property : properties) {
            String propertyKey = property.getKey();
            if ((this.key != null || propertyKey != null) && (this.key == null || !this.key.equals(propertyKey)) || !this.values.contains(property.getValue())) continue;
            return !this.negated;
        }
        return this.negated;
    }

    public String toString() {
        return "[" + this.key + " = " + this.values + "]";
    }

    public static interface Factory {
        public Condition create(@Assisted(value="key") String var1, @Assisted(value="values") String var2);
    }
}

