/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.workflow.action;

import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.hooks.workflow.ActionRequest;
import com.googlesource.gerrit.plugins.hooks.workflow.Property;
import com.googlesource.gerrit.plugins.hooks.workflow.action.Action;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEvent
implements Action {
    private static final Logger log = LoggerFactory.getLogger(LogEvent.class);

    @Inject
    public LogEvent() {
    }

    private void logProperty(Level level, Property property) {
        String message = property.toString();
        switch (level) {
            case ERROR: {
                log.error(message);
                break;
            }
            case WARN: {
                log.warn(message);
                break;
            }
            case INFO: {
                log.info(message);
                break;
            }
            case DEBUG: {
                log.debug(message);
                break;
            }
            default: {
                log.error("Undefined log level.");
            }
        }
    }

    @Override
    public void execute(String issue, ActionRequest actionRequest, Set<Property> properties) throws IOException {
        String levelParameter = actionRequest.getParameter(1);
        if (levelParameter != null) {
            levelParameter = levelParameter.toLowerCase();
        }
        Level level = Level.INFO;
        if ("error".equals(levelParameter)) {
            level = Level.ERROR;
        } else if ("warn".equals(levelParameter)) {
            level = Level.WARN;
        } else if ("info".equals(levelParameter)) {
            level = Level.INFO;
        } else if ("debug".equals(levelParameter)) {
            level = Level.DEBUG;
        }
        for (Property property : properties) {
            this.logProperty(level, property);
        }
    }

    public static interface Factory {
        public LogEvent create();
    }

    private static enum Level {
        ERROR,
        WARN,
        INFO,
        DEBUG;

    }
}

