/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.its.storyboard;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoryboardClient {
    private static final Logger log = LoggerFactory.getLogger(StoryboardClient.class);
    public static final String STORIES_ENDPOINT = "/api/v1/stories";
    public static final String SYS_INFO_ENDPOINT = "/api/v1/systeminfo";
    private final String baseUrl;
    private final String username;
    private final String password;

    public StoryboardClient(String baseUrl, String username, String password) {
        this.baseUrl = baseUrl;
        this.username = username;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData(String url) throws IOException {
        String responseJson = null;
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpGet httpget = new HttpGet(url);
            log.debug("Making request for " + httpget.getRequestLine());
            try (CloseableHttpResponse response = client.execute(httpget);){
                StatusLine sl = response.getStatusLine();
                int responseCode = sl.getStatusCode();
                if (responseCode == 200) {
                    log.debug("Retreiving data from response " + httpget.getRequestLine());
                    InputStream inputStream = response.getEntity().getContent();
                    InputStreamReader reader = new InputStreamReader(inputStream);
                    int contentLength = (int)response.getEntity().getContentLength();
                    char[] charArray = new char[contentLength];
                    reader.read(charArray);
                    responseJson = new String(charArray);
                    log.debug("Data retreived: " + responseJson);
                } else {
                    log.error("Failed request: " + httpget.getRequestLine() + " with response: " + responseCode);
                }
            }
        }
        return responseJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postData(String url, String data) throws IOException {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Authorization", "Bearer " + this.password);
            httpPost.addHeader("Content-Type", "application/json; charset=utf-8");
            httpPost.setEntity(new StringEntity(data, "utf-8"));
            log.debug("Executing request " + httpPost.getRequestLine());
            try (CloseableHttpResponse response = httpclient.execute(httpPost);){
                int responseCode = response.getStatusLine().getStatusCode();
                if (responseCode == 200) {
                    log.info("Updated " + url + " with " + data);
                } else {
                    log.error("Failed to add comment, response: " + responseCode + " (" + response.getStatusLine().getReasonPhrase() + ")");
                }
            }
        }
    }

    public String getSysInfo() throws IOException {
        return this.getData(this.baseUrl + SYS_INFO_ENDPOINT);
    }

    public String getStory(String issueId) throws IOException {
        return this.getData(this.baseUrl + STORIES_ENDPOINT + "/" + issueId);
    }

    public void addComment(String issueId, String comment) throws IOException {
        log.debug("Posting comment with data: ({},{})", (Object)issueId, (Object)comment);
        String url = this.baseUrl + STORIES_ENDPOINT + "/" + issueId + "/comments";
        String escapedComment = comment.replace("\n", "\\n");
        String json = "{\"story_id\":\"" + issueId + "\",\"content\":\"" + escapedComment + "\"}";
        this.postData(url, json);
    }
}

