/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.its.base.its;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.gerrit.common.data.RefConfigSection;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.extensions.api.projects.CommentLinkInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.config.PluginConfigFactory;
import com.google.gerrit.server.events.ChangeAbandonedEvent;
import com.google.gerrit.server.events.ChangeMergedEvent;
import com.google.gerrit.server.events.ChangeRestoredEvent;
import com.google.gerrit.server.events.CommentAddedEvent;
import com.google.gerrit.server.events.DraftPublishedEvent;
import com.google.gerrit.server.events.Event;
import com.google.gerrit.server.events.PatchSetCreatedEvent;
import com.google.gerrit.server.events.RefUpdatedEvent;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.RefPatternMatcher;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.its.base.validation.ItsAssociationPolicy;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItsConfig {
    private static final String PLUGIN = "plugin";
    private static final Logger log = LoggerFactory.getLogger(ItsConfig.class);
    private final String pluginName;
    private final ProjectCache projectCache;
    private final PluginConfigFactory pluginCfgFactory;
    private final Config gerritConfig;
    private static final ThreadLocal<Project.NameKey> currentProjectName = new ThreadLocal<Project.NameKey>(){

        @Override
        protected Project.NameKey initialValue() {
            return null;
        }
    };

    public static void setCurrentProjectName(Project.NameKey projectName) {
        currentProjectName.set(projectName);
    }

    @Inject
    public ItsConfig(@PluginName String pluginName, ProjectCache projectCache, PluginConfigFactory pluginCfgFactory, @GerritServerConfig Config gerritConfig) {
        this.pluginName = pluginName;
        this.projectCache = projectCache;
        this.pluginCfgFactory = pluginCfgFactory;
        this.gerritConfig = gerritConfig;
    }

    public boolean isEnabled(Event event) {
        if (event instanceof PatchSetCreatedEvent) {
            PatchSetCreatedEvent e = (PatchSetCreatedEvent)event;
            return this.isEnabled(e.getProjectNameKey(), e.getRefName());
        }
        if (event instanceof CommentAddedEvent) {
            CommentAddedEvent e = (CommentAddedEvent)event;
            return this.isEnabled(e.getProjectNameKey(), e.getRefName());
        }
        if (event instanceof ChangeMergedEvent) {
            ChangeMergedEvent e = (ChangeMergedEvent)event;
            return this.isEnabled(e.getProjectNameKey(), e.getRefName());
        }
        if (event instanceof ChangeAbandonedEvent) {
            ChangeAbandonedEvent e = (ChangeAbandonedEvent)event;
            return this.isEnabled(e.getProjectNameKey(), e.getRefName());
        }
        if (event instanceof ChangeRestoredEvent) {
            ChangeRestoredEvent e = (ChangeRestoredEvent)event;
            return this.isEnabled(e.getProjectNameKey(), e.getRefName());
        }
        if (event instanceof DraftPublishedEvent) {
            DraftPublishedEvent e = (DraftPublishedEvent)event;
            return this.isEnabled(e.getProjectNameKey(), e.getRefName());
        }
        if (event instanceof RefUpdatedEvent) {
            RefUpdatedEvent e = (RefUpdatedEvent)event;
            return this.isEnabled(e.getProjectNameKey(), e.getRefName());
        }
        log.debug("Event " + event + " not recognised and ignored");
        return false;
    }

    public boolean isEnabled(Project.NameKey projectNK, String refName) {
        ProjectState projectState = this.projectCache.get(projectNK);
        if (projectState == null) {
            log.error("Failed to check if " + this.pluginName + " is enabled for project " + projectNK.get() + ": Project " + projectNK.get() + " not found");
            return false;
        }
        if (this.isEnforcedByAnyParentProject(refName, projectState)) {
            return true;
        }
        return !"false".equals(this.pluginCfgFactory.getFromProjectConfigWithInheritance(projectState, this.pluginName).getString("enabled", "false")) && this.isEnabledForBranch(projectState, refName);
    }

    private boolean isEnforcedByAnyParentProject(String refName, ProjectState projectState) {
        for (ProjectState parentState : projectState.treeInOrder()) {
            PluginConfig parentCfg = this.pluginCfgFactory.getFromProjectConfig(parentState, this.pluginName);
            if (!"enforced".equals(parentCfg.getString("enabled", "false")) || !this.isEnabledForBranch(parentState, refName)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnabledForBranch(ProjectState project, String refName) {
        String[] refPatterns = this.pluginCfgFactory.getFromProjectConfigWithInheritance(project, this.pluginName).getStringList("branch");
        if (refPatterns.length == 0) {
            return true;
        }
        for (String refPattern : refPatterns) {
            if (!RefConfigSection.isValid((String)refPattern) || !this.match(refName, refPattern)) continue;
            return true;
        }
        return false;
    }

    private boolean match(String refName, String refPattern) {
        return RefPatternMatcher.getMatcher((String)refPattern).match(refName, null);
    }

    public String getCommentLinkName() {
        String ret = this.getPluginConfigString("commentlink");
        if (ret == null) {
            ret = this.pluginName;
        }
        return ret;
    }

    public Pattern getIssuePattern() {
        String match = (String)FluentIterable.from(this.getCommitLinkInfo(this.getCommentLinkName())).filter((Predicate)new Predicate<CommentLinkInfo>(){

            public boolean apply(CommentLinkInfo input) {
                return input.match != null && !input.match.trim().isEmpty();
            }
        }).transform((Function)new Function<CommentLinkInfo, String>(){

            public String apply(CommentLinkInfo input) {
                return input.match;
            }
        }).last().or((Object)this.gerritConfig.getString("commentlink", this.getCommentLinkName(), "match"));
        Pattern ret = null;
        if (match != null) {
            ret = Pattern.compile(match);
        }
        return ret;
    }

    public int getIssuePatternGroupIndex() {
        Pattern pattern = this.getIssuePattern();
        int groupCount = pattern.matcher("").groupCount();
        int index = this.getPluginConfigInt("commentlinkGroupIndex", 1);
        if (index < 0 || index > groupCount) {
            index = groupCount == 0 ? 0 : 1;
        }
        return index;
    }

    public ItsAssociationPolicy getItsAssociationPolicy() {
        ItsAssociationPolicy legacyItsAssociationPolicy = (ItsAssociationPolicy)this.gerritConfig.getEnum("commentLink", this.getCommentLinkName(), "association", (Enum)ItsAssociationPolicy.OPTIONAL);
        return this.getPluginConfigEnum("association", legacyItsAssociationPolicy);
    }

    private String getPluginConfigString(String key) {
        return this.getCurrentPluginConfig().getString(key, this.gerritConfig.getString(PLUGIN, this.pluginName, key));
    }

    private int getPluginConfigInt(String key, int defaultValue) {
        return this.getCurrentPluginConfig().getInt(key, this.gerritConfig.getInt(PLUGIN, this.pluginName, key, defaultValue));
    }

    private <T extends Enum<?>> T getPluginConfigEnum(String key, T defaultValue) {
        return (T)this.getCurrentPluginConfig().getEnum(key, this.gerritConfig.getEnum(PLUGIN, this.pluginName, key, defaultValue));
    }

    private PluginConfig getCurrentPluginConfig() {
        Project.NameKey projectName = currentProjectName.get();
        if (projectName != null) {
            try {
                return this.pluginCfgFactory.getFromProjectConfigWithInheritance(projectName, this.pluginName);
            }
            catch (NoSuchProjectException e) {
                log.error("Cannot access " + projectName + " configuration for plugin " + this.pluginName, (Throwable)e);
            }
        }
        return new PluginConfig(this.pluginName, new Config());
    }

    private List<CommentLinkInfo> getCommitLinkInfo(final String commentLinkName) {
        Project.NameKey projectName = currentProjectName.get();
        if (projectName != null) {
            List commentLinks = this.projectCache.get(projectName).getCommentLinks();
            return FluentIterable.from((Iterable)commentLinks).filter((Predicate)new Predicate<CommentLinkInfo>(){

                public boolean apply(CommentLinkInfo input) {
                    return input.name.equals(commentLinkName);
                }
            }).toList();
        }
        return Collections.emptyList();
    }
}

