/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.its.base.workflow;

import com.google.gerrit.common.Nullable;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Arrays;

public class ActionRequest {
    private final String unparsed;
    private final String[] chopped;

    @Inject
    public ActionRequest(@Nullable @Assisted String specification) {
        this.unparsed = specification == null ? "" : specification;
        this.chopped = this.unparsed.split(" ");
    }

    public String getName() {
        String ret = "";
        if (this.chopped.length > 0) {
            ret = this.chopped[0];
        }
        return ret;
    }

    public String getParameter(int i) {
        String ret = "";
        if (this.chopped.length > i) {
            ret = this.chopped[i];
        }
        return ret;
    }

    public String[] getParameters() {
        return Arrays.copyOfRange(this.chopped, 1, this.chopped.length);
    }

    public String getUnparsed() {
        return this.unparsed;
    }

    public String toString() {
        return this.getUnparsed();
    }

    public static interface Factory {
        public ActionRequest create(String var1);
    }
}

