/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.its.base.workflow.action;

import com.google.common.base.Strings;
import com.google.gerrit.server.config.SitePath;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.its.base.its.ItsFacade;
import com.googlesource.gerrit.plugins.its.base.workflow.ActionRequest;
import com.googlesource.gerrit.plugins.its.base.workflow.Property;
import com.googlesource.gerrit.plugins.its.base.workflow.action.Action;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddVelocityComment
implements Action {
    private static final Logger log = LoggerFactory.getLogger(AddVelocityComment.class);
    private static final String ITS_TEMPLATE_DIR = "etc" + File.separator + "its" + File.separator + "templates";
    private final ItsFacade its;
    private final Path sitePath;
    private final RuntimeInstance velocityRuntime;

    @Inject
    public AddVelocityComment(RuntimeInstance velocityRuntime, @SitePath Path sitePath, ItsFacade its) {
        this.velocityRuntime = velocityRuntime;
        this.sitePath = sitePath;
        this.its = its;
    }

    private VelocityContext getVelocityContext(Set<Property> properties) {
        VelocityContext velocityContext = new VelocityContext();
        for (Property property : properties) {
            String value;
            String key = property.getKey();
            if (Strings.isNullOrEmpty((String)key) || Strings.isNullOrEmpty((String)(value = property.getValue()))) continue;
            velocityContext.put(key, (Object)value);
        }
        velocityContext.put("its", (Object)new VelocityAdapterItsFacade(this.its));
        return velocityContext;
    }

    private String velocify(String template, Set<Property> properties) {
        VelocityContext context = this.getVelocityContext(properties);
        StringWriter w = new StringWriter();
        this.velocityRuntime.evaluate((Context)context, (Writer)w, "ItsComment", template);
        return w.toString();
    }

    @Override
    public void execute(String issue, ActionRequest actionRequest, Set<Property> properties) throws IOException {
        String template = null;
        String templateName = actionRequest.getParameter(1);
        if ("inline".equals(templateName)) {
            String[] allParameters = actionRequest.getParameters();
            Object[] templateParameters = Arrays.copyOfRange(allParameters, 1, allParameters.length);
            template = StringUtils.join((Object[])templateParameters, (String)" ");
        } else if (templateName.isEmpty()) {
            log.error("No template name given in " + actionRequest);
        } else {
            Path templateDir = this.sitePath.resolve(ITS_TEMPLATE_DIR);
            Path templatePath = templateDir.resolve(templateName + ".vm");
            if (Files.isReadable(templatePath)) {
                template = new String(Files.readAllBytes(templatePath));
            } else {
                log.error("Cannot read template " + templatePath);
            }
        }
        if (!Strings.isNullOrEmpty((String)template)) {
            String comment = this.velocify(template, properties);
            this.its.addComment(issue, comment);
        }
    }

    public class VelocityAdapterItsFacade {
        private final ItsFacade facade;

        private VelocityAdapterItsFacade(ItsFacade facade) {
            this.facade = facade;
        }

        public String formatLink(String url, String caption) {
            return this.facade.createLinkForWebui(url, caption);
        }

        public String formatLink(String url) {
            return this.facade.createLinkForWebui(url, url);
        }
    }

    public static interface Factory {
        public AddVelocityComment create();
    }
}

