/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.its.storyboard;

import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.its.base.its.ItsFacade;
import com.googlesource.gerrit.plugins.its.storyboard.StoryboardClient;
import java.io.IOException;
import java.net.URL;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoryboardItsFacade
implements ItsFacade {
    private final Logger log = LoggerFactory.getLogger(StoryboardItsFacade.class);
    private static final String GERRIT_CONFIG_PASSWORD = "password";
    private static final String GERRIT_CONFIG_URL = "url";
    private final StoryboardClient client;

    @Inject
    public StoryboardItsFacade(@PluginName String pluginName, @GerritServerConfig Config cfg) {
        String url = cfg.getString(pluginName, null, GERRIT_CONFIG_URL);
        String password = cfg.getString(pluginName, null, GERRIT_CONFIG_PASSWORD);
        this.client = new StoryboardClient(url, password);
    }

    @Override
    public String healthCheck(ItsFacade.Check check) throws IOException {
        return "unknown";
    }

    @Override
    public void addComment(String issueId, String comment) {
        if (!this.exists(issueId)) {
            this.log.warn("Storyboard item " + issueId + " does not exist");
            return;
        }
        try {
            this.client.addComment(issueId, comment);
        }
        catch (IOException e) {
            this.log.error("Error: unable to comment " + issueId);
        }
        this.log.info("Updated " + issueId + "with comment: " + comment);
    }

    @Override
    public void addRelatedLink(String issueId, URL relatedUrl, String description) throws IOException {
        this.addComment(issueId, "Related URL: " + this.createLinkForWebui(relatedUrl.toExternalForm(), description));
    }

    @Override
    public void performAction(String issueId, String actionString) {
        try {
            String actionName = actionString.substring(0, actionString.indexOf(" ")).toLowerCase();
            String actionValue = actionString.substring(actionString.indexOf(" ") + 1).toLowerCase();
            if (actionName.equals("set-status") && !this.client.getTaskStatus(issueId).toLowerCase().equals(actionValue)) {
                this.log.info("Updating task " + issueId + " with status: " + actionValue);
                this.client.setStatus(issueId, actionValue);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            this.log.error("Error: Invalid action: " + actionString);
        }
        catch (IOException e) {
            this.log.error("Error: Failed to peform action: " + actionString);
        }
    }

    @Override
    public boolean exists(String issudeId) {
        String info = null;
        try {
            info = this.client.getStory(issudeId);
        }
        catch (IOException e) {
            this.log.error("Error: Storyboard is not accessible at: url");
        }
        if (info != null) {
            this.log.debug("Story exists, info: " + info);
            return true;
        }
        return false;
    }

    @Override
    public String createLinkForWebui(String url, String text) {
        if (text != null && !text.isEmpty() && !text.equals(url)) {
            return "[" + text + "]" + "(" + url + ")";
        }
        return url;
    }
}

