/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.its;

import com.google.gerrit.common.data.RefConfigSection;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.config.PluginConfigFactory;
import com.google.gerrit.server.events.ChangeAbandonedEvent;
import com.google.gerrit.server.events.ChangeMergedEvent;
import com.google.gerrit.server.events.ChangeRestoredEvent;
import com.google.gerrit.server.events.CommentAddedEvent;
import com.google.gerrit.server.events.Event;
import com.google.gerrit.server.events.PatchSetCreatedEvent;
import com.google.gerrit.server.events.RefUpdatedEvent;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.RefPatternMatcher;
import com.google.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItsConfig {
    private static final Logger log = LoggerFactory.getLogger(ItsConfig.class);
    private final String pluginName;
    private final ProjectCache projectCache;
    private final PluginConfigFactory pluginCfgFactory;

    @Inject
    public ItsConfig(@PluginName String pluginName, ProjectCache projectCache, PluginConfigFactory pluginCfgFactory) {
        this.pluginName = pluginName;
        this.projectCache = projectCache;
        this.pluginCfgFactory = pluginCfgFactory;
    }

    public boolean isEnabled(Event event) {
        if (event instanceof PatchSetCreatedEvent) {
            PatchSetCreatedEvent e = (PatchSetCreatedEvent)event;
            return this.isEnabled(e.change.project, e.change.branch);
        }
        if (event instanceof CommentAddedEvent) {
            CommentAddedEvent e = (CommentAddedEvent)event;
            return this.isEnabled(e.change.project, e.change.branch);
        }
        if (event instanceof ChangeMergedEvent) {
            ChangeMergedEvent e = (ChangeMergedEvent)event;
            return this.isEnabled(e.change.project, e.change.branch);
        }
        if (event instanceof ChangeAbandonedEvent) {
            ChangeAbandonedEvent e = (ChangeAbandonedEvent)event;
            return this.isEnabled(e.change.project, e.change.branch);
        }
        if (event instanceof ChangeRestoredEvent) {
            ChangeRestoredEvent e = (ChangeRestoredEvent)event;
            return this.isEnabled(e.change.project, e.change.branch);
        }
        if (event instanceof RefUpdatedEvent) {
            RefUpdatedEvent e = (RefUpdatedEvent)event;
            return this.isEnabled(e.refUpdate.project, e.refUpdate.refName);
        }
        log.debug("Event " + event + " not recognised and ignored");
        return false;
    }

    public boolean isEnabled(String project, String branch) {
        ProjectState projectState = this.projectCache.get(new Project.NameKey(project));
        if (projectState == null) {
            log.error("Failed to check if " + this.pluginName + " is enabled for project " + project + ": Project " + project + " not found");
            return false;
        }
        for (ProjectState parentState : projectState.treeInOrder()) {
            PluginConfig parentCfg = this.pluginCfgFactory.getFromProjectConfig(parentState, this.pluginName);
            if (!"enforced".equals(parentCfg.getString("enabled")) || !this.isEnabledForBranch(parentState, branch)) continue;
            return true;
        }
        return this.pluginCfgFactory.getFromProjectConfigWithInheritance(projectState, this.pluginName).getBoolean("enabled", false) && this.isEnabledForBranch(projectState, branch);
    }

    private boolean isEnabledForBranch(ProjectState project, String branch) {
        String[] refPatterns = this.pluginCfgFactory.getFromProjectConfigWithInheritance(project, this.pluginName).getStringList("branch");
        if (refPatterns.length == 0) {
            return true;
        }
        for (String refPattern : refPatterns) {
            if (!RefConfigSection.isValid((String)refPattern) || !this.match(branch, refPattern)) continue;
            return true;
        }
        return false;
    }

    private boolean match(String branch, String refPattern) {
        return RefPatternMatcher.getMatcher((String)refPattern).match(branch, null);
    }
}

