/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.util;

import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.data.ApprovalAttribute;
import com.google.gerrit.server.events.ChangeAbandonedEvent;
import com.google.gerrit.server.events.ChangeMergedEvent;
import com.google.gerrit.server.events.ChangeRestoredEvent;
import com.google.gerrit.server.events.CommentAddedEvent;
import com.google.gerrit.server.events.DraftPublishedEvent;
import com.google.gerrit.server.events.Event;
import com.google.gerrit.server.events.PatchSetCreatedEvent;
import com.google.gerrit.server.events.RefUpdatedEvent;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.hooks.util.IssueExtractor;
import com.googlesource.gerrit.plugins.hooks.util.PropertyAttributeExtractor;
import com.googlesource.gerrit.plugins.hooks.workflow.Property;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PropertyExtractor {
    private IssueExtractor issueExtractor;
    private Property.Factory propertyFactory;
    private PropertyAttributeExtractor propertyAttributeExtractor;

    @Inject
    PropertyExtractor(IssueExtractor issueExtractor, Property.Factory propertyFactory, PropertyAttributeExtractor propertyAttributeExtractor) {
        this.issueExtractor = issueExtractor;
        this.propertyFactory = propertyFactory;
        this.propertyAttributeExtractor = propertyAttributeExtractor;
    }

    private PatchSet.Id newPatchSetId(String changeId, String patchId) {
        try {
            return new PatchSet.Id(new Change.Id(Integer.parseInt(changeId)), Integer.parseInt(patchId));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Map<String, Set<String>> extractFrom(ChangeAbandonedEvent event, Set<Property> common) {
        common.add(this.propertyFactory.create("event-type", event.type));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.change));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.abandoner, "abandoner"));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.patchSet));
        common.add(this.propertyFactory.create("reason", event.reason));
        PatchSet.Id patchSetId = this.newPatchSetId(event.change.number, event.patchSet.number);
        return this.issueExtractor.getIssueIds(event.change.project, event.patchSet.revision, patchSetId);
    }

    private Map<String, Set<String>> extractFrom(ChangeMergedEvent event, Set<Property> common) {
        common.add(this.propertyFactory.create("event-type", event.type));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.change));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.submitter, "submitter"));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.patchSet));
        PatchSet.Id patchSetId = this.newPatchSetId(event.change.number, event.patchSet.number);
        return this.issueExtractor.getIssueIds(event.change.project, event.patchSet.revision, patchSetId);
    }

    private Map<String, Set<String>> extractFrom(ChangeRestoredEvent event, Set<Property> common) {
        common.add(this.propertyFactory.create("event-type", event.type));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.change));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.restorer, "restorer"));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.patchSet));
        common.add(this.propertyFactory.create("reason", event.reason));
        PatchSet.Id patchSetId = this.newPatchSetId(event.change.number, event.patchSet.number);
        return this.issueExtractor.getIssueIds(event.change.project, event.patchSet.revision, patchSetId);
    }

    private Map<String, Set<String>> extractFrom(DraftPublishedEvent event, Set<Property> common) {
        common.add(this.propertyFactory.create("event-type", event.type));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.change));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.patchSet));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.uploader, "uploader"));
        PatchSet.Id patchSetId = this.newPatchSetId(event.change.number, event.patchSet.number);
        return this.issueExtractor.getIssueIds(event.change.project, event.patchSet.revision, patchSetId);
    }

    private Map<String, Set<String>> extractFrom(RefUpdatedEvent event, Set<Property> common) {
        common.add(this.propertyFactory.create("event-type", event.type));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.submitter, "submitter"));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.refUpdate));
        return this.issueExtractor.getIssueIds(event.refUpdate.project, event.refUpdate.newRev);
    }

    private Map<String, Set<String>> extractFrom(PatchSetCreatedEvent event, Set<Property> common) {
        common.add(this.propertyFactory.create("event-type", event.type));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.change));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.patchSet));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.uploader, "uploader"));
        PatchSet.Id patchSetId = this.newPatchSetId(event.change.number, event.patchSet.number);
        return this.issueExtractor.getIssueIds(event.change.project, event.patchSet.revision, patchSetId);
    }

    private Map<String, Set<String>> extractFrom(CommentAddedEvent event, Set<Property> common) {
        common.add(this.propertyFactory.create("event-type", event.type));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.change));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.patchSet));
        common.addAll(this.propertyAttributeExtractor.extractFrom(event.author, "commenter"));
        if (event.approvals != null) {
            for (ApprovalAttribute approvalAttribute : event.approvals) {
                common.addAll(this.propertyAttributeExtractor.extractFrom(approvalAttribute));
            }
        }
        common.add(this.propertyFactory.create("comment", event.comment));
        PatchSet.Id patchSetId = this.newPatchSetId(event.change.number, event.patchSet.number);
        return this.issueExtractor.getIssueIds(event.change.project, event.patchSet.revision, patchSetId);
    }

    public Set<Set<Property>> extractFrom(Event event) {
        Map<String, Set<String>> associations = null;
        HashSet ret = Sets.newHashSet();
        HashSet common = Sets.newHashSet();
        common.add(this.propertyFactory.create("event", event.getClass().getName()));
        if (event instanceof ChangeAbandonedEvent) {
            associations = this.extractFrom((ChangeAbandonedEvent)event, (Set<Property>)common);
        } else if (event instanceof ChangeMergedEvent) {
            associations = this.extractFrom((ChangeMergedEvent)event, (Set<Property>)common);
        } else if (event instanceof ChangeRestoredEvent) {
            associations = this.extractFrom((ChangeRestoredEvent)event, (Set<Property>)common);
        } else if (event instanceof CommentAddedEvent) {
            associations = this.extractFrom((CommentAddedEvent)event, (Set<Property>)common);
        } else if (event instanceof DraftPublishedEvent) {
            associations = this.extractFrom((DraftPublishedEvent)event, (Set<Property>)common);
        } else if (event instanceof PatchSetCreatedEvent) {
            associations = this.extractFrom((PatchSetCreatedEvent)event, (Set<Property>)common);
        } else if (event instanceof RefUpdatedEvent) {
            associations = this.extractFrom((RefUpdatedEvent)event, (Set<Property>)common);
        }
        if (associations != null) {
            for (String issue : associations.keySet()) {
                HashSet properties = Sets.newHashSet();
                Property property = this.propertyFactory.create("issue", issue);
                properties.add(property);
                for (String occurrence : associations.get(issue)) {
                    property = this.propertyFactory.create("association", occurrence);
                    properties.add(property);
                }
                properties.addAll(common);
                ret.add(properties);
            }
        }
        return ret;
    }
}

