/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.workflow;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.data.AccountAttribute;
import com.google.gerrit.server.data.ApprovalAttribute;
import com.google.gerrit.server.data.ChangeAttribute;
import com.google.gerrit.server.events.ChangeAbandonedEvent;
import com.google.gerrit.server.events.ChangeEvent;
import com.google.gerrit.server.events.ChangeMergedEvent;
import com.google.gerrit.server.events.ChangeRestoredEvent;
import com.google.gerrit.server.events.CommentAddedEvent;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.hooks.its.ItsFacade;
import com.googlesource.gerrit.plugins.hooks.util.IssueExtractor;
import com.googlesource.gerrit.plugins.hooks.workflow.GerritHookFilter;
import java.io.IOException;
import org.eclipse.jgit.lib.Config;

public class GerritHookFilterAddComment
extends GerritHookFilter {
    @Inject
    private ItsFacade its;
    @Inject
    @AnonymousCowardName
    private String anonymousCowardName;
    @Inject
    @GerritServerConfig
    private Config gerritConfig;
    @Inject
    private IssueExtractor issueExtractor;
    @Inject
    @PluginName
    private String pluginName;

    @Override
    public void doFilter(CommentAddedEvent hook) throws IOException {
        if (!this.gerritConfig.getBoolean(this.pluginName, null, "commentOnCommentAdded", true)) {
            return;
        }
        String comment = this.getComment(hook);
        this.addComment(hook.change, comment);
    }

    @Override
    public void doFilter(ChangeMergedEvent hook) throws IOException {
        if (!this.gerritConfig.getBoolean(this.pluginName, null, "commentOnChangeMerged", true)) {
            return;
        }
        String comment = this.getComment(hook);
        this.addComment(hook.change, comment);
    }

    @Override
    public void doFilter(ChangeAbandonedEvent hook) throws IOException {
        if (!this.gerritConfig.getBoolean(this.pluginName, null, "commentOnChangeAbandoned", true)) {
            return;
        }
        String comment = this.getComment(hook);
        this.addComment(hook.change, comment);
    }

    @Override
    public void doFilter(ChangeRestoredEvent hook) throws IOException {
        if (!this.gerritConfig.getBoolean(this.pluginName, null, "commentOnChangeRestored", true)) {
            return;
        }
        String comment = this.getComment(hook);
        this.addComment(hook.change, comment);
    }

    private String getCommentPrefix(ChangeAttribute change) {
        return this.getChangeIdUrl(change) + " | ";
    }

    private String formatAccountAttribute(AccountAttribute who) {
        if (who != null && !Strings.isNullOrEmpty((String)who.name)) {
            return who.name;
        }
        return this.anonymousCowardName;
    }

    private String getComment(ChangeAttribute change, ChangeEvent hook, AccountAttribute who, String what) {
        return this.getCommentPrefix(change) + "change " + what + " [by " + this.formatAccountAttribute(who) + "]";
    }

    private String getComment(ChangeRestoredEvent hook) {
        return this.getComment(hook.change, (ChangeEvent)hook, hook.restorer, "RESTORED");
    }

    private String getComment(ChangeAbandonedEvent hook) {
        return this.getComment(hook.change, (ChangeEvent)hook, hook.abandoner, "ABANDONED");
    }

    private String getComment(ChangeMergedEvent hook) {
        return this.getComment(hook.change, (ChangeEvent)hook, hook.submitter, "APPROVED and MERGED");
    }

    private String getChangeIdUrl(ChangeAttribute change) {
        String url = change.url;
        String changeId = change.id;
        return this.its.createLinkForWebui(url, "Gerrit Change " + changeId);
    }

    private String getComment(CommentAddedEvent commentAdded) {
        StringBuilder comment = new StringBuilder(this.getCommentPrefix(commentAdded.change));
        if (commentAdded.approvals != null && commentAdded.approvals.length > 0) {
            comment.append("Code-Review: ");
            for (ApprovalAttribute approval : commentAdded.approvals) {
                String value = this.getApprovalValue(approval);
                if (value == null) continue;
                comment.append(this.getApprovalType(approval) + ":" + value + " ");
            }
        }
        comment.append(commentAdded.comment + " ");
        comment.append("[by " + this.formatAccountAttribute(commentAdded.author) + "]");
        return comment.toString();
    }

    private String getApprovalValue(ApprovalAttribute approval) {
        if (approval.value.equals("0")) {
            return null;
        }
        if (approval.value.charAt(0) != '-') {
            return "+" + approval.value;
        }
        return approval.value;
    }

    private String getApprovalType(ApprovalAttribute approval) {
        if (approval.type.equalsIgnoreCase("CRVW")) {
            return "Reviewed";
        }
        if (approval.type.equalsIgnoreCase("VRIF")) {
            return "Verified";
        }
        return approval.type;
    }

    private void addComment(ChangeAttribute change, String comment) throws IOException {
        String[] issues;
        String gitComment = change.subject;
        for (String issue : issues = this.issueExtractor.getIssueIds(gitComment)) {
            this.its.addComment(issue, comment);
        }
    }
}

