/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.workflow;

import com.google.gerrit.common.data.GitWebType;
import com.google.gerrit.common.data.ParameterizedString;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.httpd.GitWebConfig;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.events.RefUpdatedEvent;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.hooks.its.ItsFacade;
import com.googlesource.gerrit.plugins.hooks.util.IssueExtractor;
import com.googlesource.gerrit.plugins.hooks.workflow.GerritHookFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritHookFilterAddRelatedLinkToGitWeb
extends GerritHookFilter {
    Logger log = LoggerFactory.getLogger(GerritHookFilterAddRelatedLinkToGitWeb.class);
    @Inject
    @GerritServerConfig
    private Config gerritConfig;
    @Inject
    private ItsFacade its;
    @Inject
    private GitWebConfig gitWebConfig;
    @Inject
    private IssueExtractor issueExtractor;
    @Inject
    @PluginName
    private String pluginName;

    @Override
    public void doFilter(RefUpdatedEvent hook) throws IOException {
        String[] issues;
        if (!this.gerritConfig.getBoolean(this.pluginName, null, "commentOnRefUpdatedGitWeb", true)) {
            return;
        }
        String gitComment = this.getComment(hook.refUpdate.project, hook.refUpdate.newRev);
        this.log.debug("Git commit " + hook.refUpdate.newRev + ": " + gitComment);
        URL gitUrl = this.getGitUrl(hook);
        if (gitUrl == null) {
            return;
        }
        for (String issue : issues = this.issueExtractor.getIssueIds(gitComment)) {
            this.log.debug("Adding GitWeb URL " + gitUrl + " to issue " + issue);
            this.its.addRelatedLink(issue, gitUrl, "Git: " + hook.refUpdate.newRev);
        }
    }

    private URL getGitUrl(RefUpdatedEvent hook) throws MalformedURLException, UnsupportedEncodingException {
        String gitWebUrl;
        String gerritCanonicalUrl = this.gerritConfig.getString("gerrit", null, "canonicalWebUrl");
        if (gerritCanonicalUrl == null) {
            this.log.info("No canonicalWebUrl configured. Skipping GitWeb link generation");
            return null;
        }
        if (!gerritCanonicalUrl.endsWith("/")) {
            gerritCanonicalUrl = gerritCanonicalUrl + "/";
        }
        if ((gitWebUrl = this.gitWebConfig.getUrl()) == null) {
            this.log.info("No url for GitWeb found. Skipping GitWeb link generation");
            return null;
        }
        if (!gitWebUrl.startsWith("http")) {
            gitWebUrl = gerritCanonicalUrl + gitWebUrl;
        }
        GitWebType gitWebType = this.gitWebConfig.getGitWebType();
        String revUrl = gitWebType.getRevision();
        ParameterizedString pattern = new ParameterizedString(revUrl);
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("project", URLEncoder.encode(gitWebType.replacePathSeparator(hook.refUpdate.project), "US-ASCII"));
        p.put("commit", hook.refUpdate.newRev);
        return new URL(gitWebUrl + pattern.replace(p));
    }
}

