/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.workflow;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.googlesource.gerrit.plugins.hooks.workflow.ActionRequest;
import com.googlesource.gerrit.plugins.hooks.workflow.Condition;
import com.googlesource.gerrit.plugins.hooks.workflow.Property;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Rule {
    private final String name;
    private List<ActionRequest> actionRequests;
    private Set<Condition> conditions;

    @Inject
    public Rule(@Assisted String name) {
        this.name = name;
        this.actionRequests = Lists.newLinkedList();
        this.conditions = Sets.newHashSet();
    }

    public String getName() {
        return this.name;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public void addActionRequest(ActionRequest actionRequest) {
        this.actionRequests.add(actionRequest);
    }

    public Collection<ActionRequest> actionRequestsFor(Iterable<Property> properties) {
        for (Condition condition : this.conditions) {
            if (condition.isMetBy(properties)) continue;
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.actionRequests);
    }

    public String toString() {
        return "[" + this.name + ", " + this.conditions + " -> " + this.actionRequests + "]";
    }

    public static interface Factory {
        public Rule create(String var1);
    }
}

