/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.workflow.action;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.hooks.its.ItsFacade;
import com.googlesource.gerrit.plugins.hooks.workflow.ActionRequest;
import com.googlesource.gerrit.plugins.hooks.workflow.Property;
import com.googlesource.gerrit.plugins.hooks.workflow.action.Action;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AddStandardComment
implements Action {
    private final ItsFacade its;

    @Inject
    public AddStandardComment(ItsFacade its) {
        this.its = its;
    }

    private String formatPerson(String prefix, Map<String, String> map) {
        String ret = Strings.nullToEmpty((String)map.get(prefix + "-name"));
        if (ret.isEmpty()) {
            ret = Strings.nullToEmpty((String)map.get(prefix + "-username"));
        }
        return ret;
    }

    private String getCommentChangeEvent(String Action2, String prefix, Map<String, String> map) {
        String url;
        String reason;
        String subject;
        String ret = "";
        String changeNumber = Strings.nullToEmpty((String)map.get("change-number"));
        if (!changeNumber.isEmpty()) {
            changeNumber = changeNumber + " ";
        }
        ret = ret + "Change " + changeNumber + Action2;
        String submitter = this.formatPerson(prefix, map);
        if (!submitter.isEmpty()) {
            ret = ret + " by " + submitter;
        }
        if (!(subject = Strings.nullToEmpty((String)map.get("subject"))).isEmpty()) {
            ret = ret + ":\n" + subject;
        }
        if (!(reason = Strings.nullToEmpty((String)map.get("reason"))).isEmpty()) {
            ret = ret + "\n\nReason:\n" + reason;
        }
        if (!(url = Strings.nullToEmpty((String)map.get("change-url"))).isEmpty()) {
            ret = ret + "\n\n" + this.its.createLinkForWebui(url, url);
        }
        return ret;
    }

    private String getCommentChangeAbandoned(Map<String, String> map) {
        return this.getCommentChangeEvent("abandoned", "abandoner", map);
    }

    private String getCommentChangeMerged(Map<String, String> map) {
        return this.getCommentChangeEvent("merged", "submitter", map);
    }

    private String getCommentChangeRestored(Map<String, String> map) {
        return this.getCommentChangeEvent("restored", "restorer", map);
    }

    private String getCommentPatchSetCreated(Map<String, String> map) {
        return this.getCommentChangeEvent("had a related patch set uploaded", "uploader", map);
    }

    @Override
    public void execute(String issue, ActionRequest actionRequest, Set<Property> properties) throws IOException {
        String comment = "";
        HashMap map = Maps.newHashMap();
        for (Property property : properties) {
            String current = property.getValue();
            if (Strings.isNullOrEmpty((String)current)) continue;
            String key = property.getKey();
            String old = Strings.nullToEmpty((String)((String)map.get(key)));
            if (!old.isEmpty()) {
                old = old + ", ";
            }
            map.put(key, old + current);
        }
        String eventType = (String)map.get("event-type");
        if ("change-abandoned".equals(eventType)) {
            comment = this.getCommentChangeAbandoned(map);
        } else if ("change-merged".equals(eventType)) {
            comment = this.getCommentChangeMerged(map);
        } else if ("change-restored".equals(eventType)) {
            comment = this.getCommentChangeRestored(map);
        } else if ("patchset-created".equals(eventType)) {
            comment = this.getCommentPatchSetCreated(map);
        }
        if (!Strings.isNullOrEmpty((String)comment)) {
            this.its.addComment(issue, comment);
        }
    }

    public static interface Factory {
        public AddStandardComment create();
    }
}

