/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.javamelody;

import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.httpd.AllRequestFilter;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.CapabilityControl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.MonitoringFilter;

@Singleton
class GerritMonitoringFilter
extends AllRequestFilter {
    private final JavamelodyFilter monitoring;
    private final Provider<CurrentUser> userProvider;
    private final String pluginName;

    @Inject
    GerritMonitoringFilter(JavamelodyFilter monitoring, Provider<CurrentUser> userProvider, @PluginName String pluginName) {
        this.monitoring = monitoring;
        this.userProvider = userProvider;
        this.pluginName = pluginName;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.canMonitor(httpRequest)) {
            this.monitoring.doFilter(request, response, chain);
        } else {
            httpResponse.sendError(403, "Forbidden access");
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.monitoring.init(config);
    }

    public void destroy() {
        this.monitoring.destroy();
    }

    private boolean canMonitor(HttpServletRequest httpRequest) {
        if (httpRequest.getRequestURI().equals(this.monitoring.getJavamelodyUrl(httpRequest))) {
            if (((CurrentUser)this.userProvider.get()).isIdentifiedUser()) {
                CapabilityControl ctl = ((CurrentUser)this.userProvider.get()).getCapabilities();
                return ctl.canAdministrateServer() || ctl.canPerform(String.format("%s-%s", this.pluginName, "monitoring"));
            }
            return false;
        }
        return true;
    }

    static class JavamelodyFilter
    extends MonitoringFilter {
        JavamelodyFilter() {
        }

        public String getJavamelodyUrl(HttpServletRequest httpRequest) {
            return this.getMonitoringUrl(httpRequest);
        }
    }
}

