/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Font;
import java.awt.Paint;
import org.jrobin.core.Util;
import org.jrobin.graph.ImageParameters;
import org.jrobin.graph.ImageWorker;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.RrdGraphDef;

class ValueAxisLogarithmic
implements RrdGraphConstants {
    private static final double[][] yloglab = new double[][]{{1.0E9, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1000.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 2.5, 5.0, 7.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 2.0, 4.0, 6.0, 8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    private RrdGraph rrdGraph;
    private ImageParameters im;
    private ImageWorker worker;
    private RrdGraphDef gdef;

    ValueAxisLogarithmic(RrdGraph rrdGraph) {
        this.rrdGraph = rrdGraph;
        this.im = rrdGraph.im;
        this.gdef = rrdGraph.gdef;
        this.worker = rrdGraph.worker;
    }

    boolean draw() {
        int y;
        int i;
        Font font = this.gdef.smallFont;
        Paint gridColor = this.gdef.colors[4];
        Paint mGridColor = this.gdef.colors[5];
        Paint fontColor = this.gdef.colors[6];
        int fontHeight = (int)Math.ceil(this.rrdGraph.getSmallFontHeight());
        int labelOffset = (int)(this.worker.getFontAscent(font) / 2.0);
        double pixpex = (double)this.im.ysize / (Math.log10(this.im.maxval) - Math.log10(this.im.minval));
        if (Double.isNaN(pixpex)) {
            return false;
        }
        int minoridx = 0;
        int majoridx = 0;
        int i2 = 0;
        while (yloglab[i2][0] > 0.0) {
            double minstep = Math.log10(yloglab[i2][0]);
            int ii = 1;
            while (yloglab[i2][ii + 1] > 0.0) {
                if (yloglab[i2][ii + 2] == 0.0) {
                    minstep = Math.log10(yloglab[i2][ii + 1]) - Math.log10(yloglab[i2][ii]);
                    break;
                }
                ++ii;
            }
            double pixperstep = pixpex * minstep;
            if (pixperstep > 5.0) {
                minoridx = i2;
            }
            if (pixperstep > (double)(2 * fontHeight)) {
                majoridx = i2;
            }
            ++i2;
        }
        int x0 = this.im.xorigin;
        int x1 = x0 + this.im.xsize;
        double value = Math.pow(10.0, Math.log10(this.im.minval) - Math.log10(this.im.minval) % Math.log10(yloglab[minoridx][0]));
        while (value <= this.im.maxval) {
            if (!(value < this.im.minval)) {
                i = 0;
                while (yloglab[minoridx][++i] > 0.0) {
                    y = this.rrdGraph.mapper.ytr(value * yloglab[minoridx][i]);
                    if (y <= this.im.yorigin - this.im.ysize) break;
                    this.worker.drawLine(x0 - 1, y, x0 + 1, y, gridColor, TICK_STROKE);
                    this.worker.drawLine(x1 - 1, y, x1 + 1, y, gridColor, TICK_STROKE);
                    this.worker.drawLine(x0, y, x1, y, gridColor, GRID_STROKE);
                }
            }
            value *= yloglab[minoridx][0];
        }
        value = Math.pow(10.0, Math.log10(this.im.minval) - Math.log10(this.im.minval) % Math.log10(yloglab[majoridx][0]));
        while (value <= this.im.maxval) {
            if (!(value < this.im.minval)) {
                i = 0;
                while (yloglab[majoridx][++i] > 0.0) {
                    y = this.rrdGraph.mapper.ytr(value * yloglab[majoridx][i]);
                    if (y <= this.im.yorigin - this.im.ysize) break;
                    this.worker.drawLine(x0 - 2, y, x0 + 2, y, mGridColor, TICK_STROKE);
                    this.worker.drawLine(x1 - 2, y, x1 + 2, y, mGridColor, TICK_STROKE);
                    this.worker.drawLine(x0, y, x1, y, mGridColor, GRID_STROKE);
                    String graph_label = Util.sprintf("%3.0e", value * yloglab[majoridx][i]);
                    int length = (int)this.worker.getStringWidth(graph_label, font);
                    this.worker.drawString(graph_label, x0 - length - 7, y + labelOffset, font, fontColor);
                }
            }
            value *= yloglab[majoridx][0];
        }
        return true;
    }
}

