/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.VMOption;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.Counter;
import net.bull.javamelody.HtmlAbstractReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JobInformations;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MailReport;
import net.bull.javamelody.PID;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.QuartzAdapter;
import net.bull.javamelody.SessionListener;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.quartz.JobDetail;
import org.quartz.Scheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Action
extends Enum<Action> {
    public static final /* enum */ Action MAIL_TEST = new Action("");
    public static final /* enum */ Action CLEAR_COUNTER = new Action("http");
    public static final /* enum */ Action GC = new Action("systeminfo");
    public static final /* enum */ Action INVALIDATE_SESSIONS = new Action("systeminfo");
    public static final /* enum */ Action INVALIDATE_SESSION = new Action("");
    public static final /* enum */ Action HEAP_DUMP = new Action("systeminfo");
    public static final /* enum */ Action CLEAR_CACHES = new Action("caches");
    public static final /* enum */ Action CLEAR_CACHE = new Action("caches");
    public static final /* enum */ Action KILL_THREAD = new Action("threads");
    public static final /* enum */ Action PAUSE_JOB = new Action("jobs");
    public static final /* enum */ Action RESUME_JOB = new Action("jobs");
    public static final /* enum */ Action CLEAR_HOTSPOTS = new Action("");
    public static final /* enum */ Action PURGE_OBSOLETE_FILES = new Action("bottom");
    static final String JAVA_VENDOR;
    static final boolean GC_ENABLED;
    static final boolean HEAP_DUMP_ENABLED;
    private static final String ALL = "all";
    private final String contextName;
    private static final /* synthetic */ Action[] $VALUES;

    public static Action[] values() {
        return (Action[])$VALUES.clone();
    }

    public static Action valueOf(String name) {
        return Enum.valueOf(Action.class, name);
    }

    private Action(String contextName) {
        this.contextName = contextName;
    }

    String getContextName(String counterName) {
        if (this == CLEAR_COUNTER && !ALL.equalsIgnoreCase(counterName)) {
            return counterName;
        }
        return this.contextName;
    }

    static Action valueOfIgnoreCase(String action) {
        return Action.valueOf(action.toUpperCase(Locale.getDefault()).trim());
    }

    static void checkSystemActionsEnabled() {
        if (!Parameters.isSystemActionsEnabled()) {
            throw new IllegalStateException(I18N.getString("Actions_non_activees"));
        }
    }

    String execute(Collector collector, CollectorServer collectorServer, String counterName, String sessionId, String threadId, String jobId, String cacheId) throws IOException {
        String messageForReport;
        switch (this) {
            case CLEAR_COUNTER: {
                assert (collector != null);
                assert (counterName != null);
                messageForReport = this.clearCounter(collector, counterName);
                break;
            }
            case MAIL_TEST: {
                assert (collector != null);
                messageForReport = this.mailTest(collector, collectorServer);
                break;
            }
            case GC: {
                if (GC_ENABLED) {
                    long before = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    this.gc();
                    long after = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    messageForReport = I18N.getFormattedString("ramasse_miette_execute", (before - after) / 1024L);
                    break;
                }
                messageForReport = I18N.getString("ramasse_miette_desactive");
                break;
            }
            case HEAP_DUMP: {
                if (HEAP_DUMP_ENABLED) {
                    if (JAVA_VENDOR.contains("IBM")) {
                        this.ibmHeapDump();
                        messageForReport = I18N.getString("heap_dump_genere_ibm");
                        break;
                    }
                    String heapDumpPath = this.heapDump().getPath();
                    messageForReport = I18N.getFormattedString("heap_dump_genere", heapDumpPath.replace('\\', '/'));
                    break;
                }
                messageForReport = I18N.getString("heap_dump_not_good");
                break;
            }
            case INVALIDATE_SESSIONS: {
                SessionListener.invalidateAllSessions();
                messageForReport = I18N.getString("sessions_http_invalidees");
                break;
            }
            case INVALIDATE_SESSION: {
                assert (sessionId != null);
                SessionListener.invalidateSession(sessionId);
                messageForReport = I18N.getString("session_http_invalidee");
                break;
            }
            case CLEAR_CACHES: {
                this.clearCaches();
                messageForReport = I18N.getString("caches_purges");
                break;
            }
            case CLEAR_CACHE: {
                this.clearCache(cacheId);
                messageForReport = I18N.getFormattedString("cache_purge", cacheId);
                break;
            }
            case KILL_THREAD: {
                assert (threadId != null);
                messageForReport = this.killThread(threadId);
                break;
            }
            case PAUSE_JOB: {
                assert (jobId != null);
                messageForReport = this.pauseJob(jobId);
                break;
            }
            case RESUME_JOB: {
                assert (jobId != null);
                messageForReport = this.resumeJob(jobId);
                break;
            }
            case CLEAR_HOTSPOTS: {
                assert (collector.getSamplingProfiler() != null);
                collector.getSamplingProfiler().clear();
                messageForReport = I18N.getString("hotspots_cleared");
                break;
            }
            case PURGE_OBSOLETE_FILES: {
                assert (collector != null);
                collector.deleteObsoleteFiles();
                messageForReport = I18N.getString("fichiers_obsoletes_purges") + '\n' + I18N.getString("Usage_disque") + ": " + (collector.getDiskUsage() / 1024L / 1024L + 1L) + ' ' + I18N.getString("Mo");
                break;
            }
            default: {
                throw new IllegalStateException(this.toString());
            }
        }
        if (messageForReport != null) {
            LOG.debug("Action '" + (Object)((Object)this) + "' executed. Result: " + messageForReport.replace('\n', ' '));
        }
        return messageForReport;
    }

    private String clearCounter(Collector collector, String counterName) {
        String messageForReport;
        if (ALL.equalsIgnoreCase(counterName)) {
            for (Counter counter : collector.getCounters()) {
                collector.clearCounter(counter.getName());
            }
            messageForReport = I18N.getFormattedString("Toutes_statistiques_reinitialisees", counterName);
        } else {
            collector.clearCounter(counterName);
            messageForReport = I18N.getFormattedString("Statistiques_reinitialisees", counterName);
        }
        return messageForReport;
    }

    private String mailTest(Collector collector, CollectorServer collectorServer) {
        if (!HtmlAbstractReport.isPdfEnabled()) {
            throw new IllegalStateException("itext classes not found: add the itext dependency");
        }
        if (Parameters.getParameter(Parameter.MAIL_SESSION) == null) {
            throw new IllegalStateException("mail-session has no value: add the mail-session parameter");
        }
        if (Parameters.getParameter(Parameter.ADMIN_EMAILS) == null) {
            throw new IllegalStateException("admin-emails has no value: add the admin-emails parameter");
        }
        try {
            if (collectorServer == null) {
                new MailReport().sendReportMailForLocalServer(collector, Period.JOUR);
            } else {
                new MailReport().sendReportMail(collector, true, collectorServer.getJavaInformationsByApplication(collector.getApplication()), Period.JOUR);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "Mail sent with pdf report for the day to admins";
    }

    private File heapDump() throws IOException {
        boolean gcBeforeHeapDump = true;
        try {
            String path;
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectInstance instance = platformMBeanServer.getObjectInstance(new ObjectName("com.sun.management:type=HotSpotDiagnostic"));
            Object mxBean = platformMBeanServer.instantiate(instance.getClassName());
            VMOption vmOption = ((HotSpotDiagnosticMXBean)mxBean).getVMOption("HeapDumpPath");
            String heapDumpPath = vmOption == null ? null : vmOption.getValue();
            if (heapDumpPath == null || heapDumpPath.length() == 0) {
                path = Parameters.TEMPORARY_DIRECTORY.getPath();
            } else {
                File file = new File(heapDumpPath);
                if (file.exists()) {
                    path = file.isDirectory() ? heapDumpPath : file.getParent();
                } else {
                    if (!file.mkdirs()) {
                        throw new IllegalStateException("Can't create directory " + file.getPath());
                    }
                    path = heapDumpPath;
                }
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault());
            File heapDumpFile = new File(path, "heapdump-" + Parameters.getHostName() + '-' + dateFormat.format(new Date()) + ".hprof");
            if (heapDumpFile.exists()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
                return this.heapDump();
            }
            ((HotSpotDiagnosticMXBean)mxBean).dumpHeap(heapDumpFile.getPath(), true);
            return heapDumpFile;
        }
        catch (JMException e) {
            throw new IllegalStateException(e);
        }
    }

    private void ibmHeapDump() {
        try {
            Class<?> dumpClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.ibm.jvm.Dump");
            Class<?>[] argTypes = null;
            Method dump = dumpClass.getMethod("HeapDump", argTypes);
            Object[] args = null;
            dump.invoke(null, args);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void gc() {
        Runtime.getRuntime().gc();
    }

    private void clearCaches() {
        List allCacheManagers = CacheManager.ALL_CACHE_MANAGERS;
        for (CacheManager cacheManager : allCacheManagers) {
            cacheManager.clearAll();
        }
    }

    private void clearCache(String cacheId) {
        List allCacheManagers = CacheManager.ALL_CACHE_MANAGERS;
        for (CacheManager cacheManager : allCacheManagers) {
            Cache cache = cacheManager.getCache(cacheId);
            if (cache == null) continue;
            cache.removeAll();
        }
    }

    private String killThread(String threadId) {
        String[] values = threadId.split("_");
        if (values.length != 3) {
            throw new IllegalArgumentException(threadId);
        }
        if (values[0].equals(PID.getPID()) && values[1].equals(Parameters.getHostAddress())) {
            long myThreadId = Long.parseLong(values[2]);
            List<Thread> threads = JavaInformations.getThreadsFromThreadGroups();
            for (Thread thread : threads) {
                if (thread.getId() != myThreadId) continue;
                this.stopThread(thread);
                return I18N.getFormattedString("Thread_tue", thread.getName());
            }
            return I18N.getString("Thread_non_trouve");
        }
        return null;
    }

    private void stopThread(Thread thread) {
        thread.stop();
    }

    private String pauseJob(String jobId) {
        if (ALL.equalsIgnoreCase(jobId)) {
            this.pauseAllJobs();
            return I18N.getString("all_jobs_paused");
        }
        String[] values = jobId.split("_");
        if (values.length != 3) {
            throw new IllegalArgumentException(jobId);
        }
        if (values[0].equals(PID.getPID()) && values[1].equals(Parameters.getHostAddress())) {
            if (this.pauseJobById(Integer.parseInt(values[2]))) {
                return I18N.getString("job_paused");
            }
            return I18N.getString("job_notfound");
        }
        return null;
    }

    private boolean pauseJobById(int myJobId) {
        try {
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                for (JobDetail jobDetail : JobInformations.getAllJobsOfScheduler(scheduler)) {
                    if (QuartzAdapter.getSingleton().getJobFullName(jobDetail).hashCode() != myJobId) continue;
                    QuartzAdapter.getSingleton().pauseJob(jobDetail, scheduler);
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void pauseAllJobs() {
        try {
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                scheduler.pauseAll();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String resumeJob(String jobId) {
        if (ALL.equalsIgnoreCase(jobId)) {
            this.resumeAllJobs();
            return I18N.getString("all_jobs_resumed");
        }
        String[] values = jobId.split("_");
        if (values.length != 3) {
            throw new IllegalArgumentException(jobId);
        }
        if (values[0].equals(PID.getPID()) && values[1].equals(Parameters.getHostAddress())) {
            if (this.resumeJobById(Integer.parseInt(values[2]))) {
                return I18N.getString("job_resumed");
            }
            return I18N.getString("job_notfound");
        }
        return null;
    }

    private boolean resumeJobById(int myJobId) {
        try {
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                for (JobDetail jobDetail : JobInformations.getAllJobsOfScheduler(scheduler)) {
                    if (QuartzAdapter.getSingleton().getJobFullName(jobDetail).hashCode() != myJobId) continue;
                    QuartzAdapter.getSingleton().resumeJob(jobDetail, scheduler);
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void resumeAllJobs() {
        try {
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                scheduler.resumeAll();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        $VALUES = new Action[]{MAIL_TEST, CLEAR_COUNTER, GC, INVALIDATE_SESSIONS, INVALIDATE_SESSION, HEAP_DUMP, CLEAR_CACHES, CLEAR_CACHE, KILL_THREAD, PAUSE_JOB, RESUME_JOB, CLEAR_HOTSPOTS, PURGE_OBSOLETE_FILES};
        JAVA_VENDOR = System.getProperty("java.vendor");
        GC_ENABLED = !ManagementFactory.getRuntimeMXBean().getInputArguments().contains("-XX:+DisableExplicitGC");
        HEAP_DUMP_ENABLED = "1.6".compareTo(System.getProperty("java.version")) < 0 && (JAVA_VENDOR.contains("Sun") || JAVA_VENDOR.contains("Oracle") || JAVA_VENDOR.contains("IBM"));
    }
}

