/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Collector;
import net.bull.javamelody.FilterContext;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MonitoringController;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

public class ReportServlet
extends HttpServlet {
    static final String FILTER_CONTEXT_KEY = "javamelody.filterContext";
    private static final long serialVersionUID = 1L;
    private ServletConfig servletConfig;
    private Pattern allowedAddrPattern;

    public void init(ServletConfig config) {
        this.servletConfig = config;
        if (Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN) != null) {
            this.allowedAddrPattern = Pattern.compile(Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN));
        }
        LOG.debug("JavaMelody report servlet initialized");
    }

    public void destroy() {
        this.servletConfig = null;
    }

    protected void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        if (this.isRequestNotAllowed(httpRequest)) {
            LOG.debug("Forbidden access to monitoring from " + httpRequest.getRemoteAddr());
            httpResponse.sendError(403, "Forbidden access");
            return;
        }
        FilterContext filterContext = (FilterContext)this.servletConfig.getServletContext().getAttribute(FILTER_CONTEXT_KEY);
        Collector collector = filterContext.getCollector();
        MonitoringController monitoringController = new MonitoringController(collector, null);
        monitoringController.doActionIfNeededAndReport(httpRequest, httpResponse, this.servletConfig.getServletContext());
    }

    private boolean isRequestNotAllowed(HttpServletRequest httpRequest) {
        return this.allowedAddrPattern != null && !this.allowedAddrPattern.matcher(httpRequest.getRemoteAddr()).matches();
    }
}

