/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.io.IOException;
import org.jrobin.cmd.ColonSplitter;
import org.jrobin.cmd.RrdToolCmd;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;

class RrdUpdateCmd
extends RrdToolCmd {
    RrdUpdateCmd() {
    }

    String getCmdType() {
        return "update";
    }

    Object execute() throws RrdException, IOException {
        String template = this.getOptionValue("t", "template");
        String[] dsNames = template != null ? new ColonSplitter(template).split() : null;
        String[] words = this.getRemainingWords();
        if (words.length < 3) {
            throw new RrdException("Insufficent number of parameters for rrdupdate command");
        }
        String path = words[1];
        RrdDb rrdDb = RrdUpdateCmd.getRrdDbReference(path);
        try {
            if (dsNames != null) {
                String[] stringArray = dsNames;
                int n = dsNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String dsName = stringArray[n2];
                    if (!rrdDb.containsDs(dsName)) {
                        throw new RrdException("Invalid datasource name: " + dsName);
                    }
                    ++n2;
                }
            }
            long timestamp = -1L;
            int i = 2;
            while (i < words.length) {
                String[] tokens = new ColonSplitter(words[i]).split();
                if (dsNames != null && dsNames.length + 1 != tokens.length) {
                    throw new RrdException("Template requires " + dsNames.length + " values, " + (tokens.length - 1) + " value(s) found in: " + words[i]);
                }
                int dsCount = rrdDb.getHeader().getDsCount();
                if (dsNames == null && dsCount + 1 != tokens.length) {
                    throw new RrdException("Expected " + dsCount + " values, " + (tokens.length - 1) + " value(s) found in: " + words[i]);
                }
                timestamp = Util.getTimestamp(tokens[0]);
                Sample sample = rrdDb.createSample(timestamp);
                int j = 1;
                while (j < tokens.length) {
                    if (dsNames == null) {
                        sample.setValue(j - 1, RrdUpdateCmd.parseDouble(tokens[j]));
                    } else {
                        sample.setValue(dsNames[j - 1], RrdUpdateCmd.parseDouble(tokens[j]));
                    }
                    ++j;
                }
                sample.update();
                ++i;
            }
            Long l = timestamp;
            return l;
        }
        finally {
            RrdUpdateCmd.releaseRrdDbReference(rrdDb);
        }
    }
}

