/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.data;

import java.io.IOException;
import org.jrobin.core.FetchData;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.data.Aggregates;
import org.jrobin.data.Aggregator;
import org.jrobin.data.Source;

class Def
extends Source {
    private String path;
    private String dsName;
    private String consolFun;
    private String backend;
    private FetchData fetchData;

    Def(String name, FetchData fetchData) {
        this(name, null, name, null, null);
        this.setFetchData(fetchData);
    }

    Def(String name, String path, String dsName, String consolFunc) {
        this(name, path, dsName, consolFunc, null);
    }

    Def(String name, String path, String dsName, String consolFunc, String backend) {
        super(name);
        this.path = path;
        this.dsName = dsName;
        this.consolFun = consolFunc;
        this.backend = backend;
    }

    String getPath() {
        return this.path;
    }

    String getCanonicalPath() throws IOException {
        return Util.getCanonicalPath(this.path);
    }

    String getDsName() {
        return this.dsName;
    }

    String getConsolFun() {
        return this.consolFun;
    }

    String getBackend() {
        return this.backend;
    }

    boolean isCompatibleWith(Def def) throws IOException {
        return this.getCanonicalPath().equals(def.getCanonicalPath()) && this.getConsolFun().equals(def.consolFun) && (this.backend == null && def.backend == null || this.backend != null && def.backend != null && this.backend.equals(def.backend));
    }

    void setFetchData(FetchData fetchData) {
        this.fetchData = fetchData;
    }

    long[] getRrdTimestamps() {
        return this.fetchData.getTimestamps();
    }

    double[] getRrdValues() throws RrdException {
        return this.fetchData.getValues(this.dsName);
    }

    long getArchiveEndTime() {
        return this.fetchData.getArcEndTime();
    }

    long getFetchStep() {
        return this.fetchData.getStep();
    }

    Aggregates getAggregates(long tStart, long tEnd) throws RrdException {
        long[] t = this.getRrdTimestamps();
        double[] v = this.getRrdValues();
        Aggregator agg = new Aggregator(t, v);
        return agg.getAggregates(tStart, tEnd);
    }

    double getPercentile(long tStart, long tEnd, double percentile) throws RrdException {
        long[] t = this.getRrdTimestamps();
        double[] v = this.getRrdValues();
        Aggregator agg = new Aggregator(t, v);
        return agg.getPercentile(tStart, tEnd, percentile);
    }

    boolean isLoaded() {
        return this.fetchData != null;
    }
}

