/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import net.bull.javamelody.JdbcWrapper;

public class MonitoringInitialContextFactory
implements InitialContextFactory {
    private static String initialContextFactory;

    static void init() {
        initialContextFactory = System.getProperty("java.naming.factory.initial");
        System.setProperty("java.naming.factory.initial", MonitoringInitialContextFactory.class.getName());
    }

    static void stop() {
        if (MonitoringInitialContextFactory.class.getName().equals(System.getProperty("java.naming.factory.initial"))) {
            System.setProperty("java.naming.factory.initial", initialContextFactory);
        }
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        try {
            Class<?> clazz = Class.forName(initialContextFactory);
            InitialContextFactory icf = (InitialContextFactory)clazz.newInstance();
            Context context = icf.getInitialContext(environment);
            JdbcWrapper jdbcWrapper = JdbcWrapper.SINGLETON;
            return jdbcWrapper.createContextProxy(context);
        }
        catch (ClassNotFoundException e) {
            throw MonitoringInitialContextFactory.createNamingException(e);
        }
        catch (InstantiationException e) {
            throw MonitoringInitialContextFactory.createNamingException(e);
        }
        catch (IllegalAccessException e) {
            throw MonitoringInitialContextFactory.createNamingException(e);
        }
    }

    private static NoInitialContextException createNamingException(Exception e) {
        NoInitialContextException ex = new NoInitialContextException(e.toString());
        ex.initCause(e);
        return ex;
    }
}

