/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Base64Coder;
import net.bull.javamelody.LOG;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

class HttpAuth {
    private final Pattern allowedAddrPattern = HttpAuth.getAllowedAddrPattern();
    private final List<String> authorizedUsers = HttpAuth.getAuthorizedUsers();

    HttpAuth() {
    }

    private static Pattern getAllowedAddrPattern() {
        if (Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN) != null) {
            return Pattern.compile(Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN));
        }
        return null;
    }

    private static List<String> getAuthorizedUsers() {
        String authUsersInParam = Parameters.getParameter(Parameter.AUTHORIZED_USERS);
        if (authUsersInParam != null && !authUsersInParam.trim().isEmpty()) {
            ArrayList<String> authorizedUsers = new ArrayList<String>();
            for (String authUser : authUsersInParam.split("[\n,]")) {
                String authUserTrim = authUser.trim();
                if (authUserTrim.isEmpty()) continue;
                authorizedUsers.add(authUserTrim);
                LOG.debug("Authorized user : " + authUserTrim.split(":", 2)[0]);
            }
            return authorizedUsers;
        }
        return null;
    }

    boolean isAllowed(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (!this.isRequestAllowed(httpRequest)) {
            LOG.debug("Forbidden access to monitoring from " + httpRequest.getRemoteAddr());
            httpResponse.sendError(403, "Forbidden access");
            return false;
        }
        if (!this.isUserAuthorized(httpRequest)) {
            httpResponse.setHeader("WWW-Authenticate", "BASIC realm=\"JavaMelody\"");
            httpResponse.sendError(401);
            return false;
        }
        return true;
    }

    private boolean isRequestAllowed(HttpServletRequest httpRequest) {
        return this.allowedAddrPattern == null || this.allowedAddrPattern.matcher(httpRequest.getRemoteAddr()).matches();
    }

    private boolean isUserAuthorized(HttpServletRequest httpRequest) {
        if (this.authorizedUsers == null) {
            return true;
        }
        String auth = httpRequest.getHeader("Authorization");
        if (auth == null) {
            return false;
        }
        if (!auth.toUpperCase(Locale.ENGLISH).startsWith("BASIC ")) {
            return false;
        }
        String userpassEncoded = auth.substring("BASIC ".length());
        String userpassDecoded = Base64Coder.decodeString(userpassEncoded);
        return this.authorizedUsers.contains(userpassDecoded);
    }
}

