/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import net.bull.javamelody.Counter;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

public class MonitoringInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Counter EJB_COUNTER = MonitoringProxy.getEjbCounter();
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(EJB_COUNTER.getName());
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));

    public MonitoringInterceptor() {
        EJB_COUNTER.setDisplayed(!COUNTER_HIDDEN);
        EJB_COUNTER.setUsed(true);
        LOG.debug("ejb interceptor initialized");
    }

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        if (DISABLED || !EJB_COUNTER.isDisplayed()) {
            return context.proceed();
        }
        String requestName = this.getRequestName(context);
        boolean systemError = false;
        try {
            EJB_COUNTER.bindContextIncludingCpu(requestName);
            Object object = context.proceed();
            return object;
        }
        catch (Error e) {
            systemError = true;
            throw e;
        }
        finally {
            EJB_COUNTER.addRequestForCurrentContext(systemError);
        }
    }

    protected String getRequestName(InvocationContext context) {
        Method method = context.getMethod();
        String requestName = method.getDeclaringClass().getSimpleName() + '.' + method.getName();
        return requestName;
    }
}

