/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("java.awt.headless", "true");
        File me = Main.whoAmI();
        Main.getSystemOutputStream().println("Running from: " + me);
        System.setProperty("executable-war", me.getAbsolutePath());
        File tmpJar = Main.extractFromJar("/winstone-hudson.jar", "winstone", "jar");
        File tempFile = File.createTempFile("dummy", "dummy");
        Main.deleteContents(new File(tempFile.getParent(), "winstone/" + me.getName()));
        Main.deleteFile(tempFile);
        URLClassLoader cl = new URLClassLoader(new URL[]{tmpJar.toURI().toURL()});
        Class<?> launcher = cl.loadClass("winstone.Launcher");
        Method mainMethod = launcher.getMethod("main", String[].class);
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        arguments.add(0, "--warfile=" + me.getAbsolutePath());
        Field usage = launcher.getField("USAGE");
        usage.set(null, "JavaMelody Monitoring Collect Server \nUsage: java -jar javamelody.war [--option=value] [--option=value]\n\nOptions:\n   --config                 = load configuration properties from here. Default is ./winstone.properties\n   --prefix                 = add this prefix to all URLs (eg http://localhost:8080/prefix/resource). Default is none\n   --commonLibFolder        = folder for additional jar files. Default is ./lib\n   \n   --logfile                = redirect log messages to this file\n   --logThrowingLineNo      = show the line no that logged the message (slow). Default is false\n   --logThrowingThread      = show the thread that logged the message. Default is false\n   --debug                  = set the level of debug msgs (1-9). Default is 5 (INFO level)\n\n   --httpPort               = set the http listening port. -1 to disable, Default is 8080\n   --httpListenAddress      = set the http listening address. Default is all interfaces\n   --httpDoHostnameLookups  = enable host name lookups on incoming http connections (true/false). Default is false\n   --httpsPort              = set the https listening port. -1 to disable, Default is disabled\n   --httpsListenAddress     = set the https listening address. Default is all interfaces\n   --httpsDoHostnameLookups = enable host name lookups on incoming https connections (true/false). Default is false\n   --httpsKeyStore          = the location of the SSL KeyStore file. Default is ./winstone.ks\n   --httpsKeyStorePassword  = the password for the SSL KeyStore file. Default is null\n   --httpsKeyManagerType    = the SSL KeyManagerFactory type (eg SunX509, IbmX509). Default is SunX509\n   --ajp13Port              = set the ajp13 listening port. -1 to disable, Default is 8009\n   --ajp13ListenAddress     = set the ajp13 listening address. Default is all interfaces\n   --controlPort            = set the shutdown/control port. -1 to disable, Default disabled\n   \n   --handlerCountStartup    = set the no of worker threads to spawn at startup. Default is 5\n   --handlerCountMax        = set the max no of worker threads to allow. Default is 300\n   --handlerCountMaxIdle    = set the max no of idle worker threads to allow. Default is 50\n   \n   --simulateModUniqueId    = simulate the apache mod_unique_id function. Default is false\n   --useSavedSessions       = enables session persistence (true/false). Default is false\n   --usage / --help         = show this message\n   \nSecurity options:\n   --realmClassName               = Set the realm class to use for user authentication. Defaults to ArgumentsRealm class\n   \n   --argumentsRealm.passwd.<user> = Password for user <user>. Only valid for the ArgumentsRealm realm class\n   --argumentsRealm.roles.<user>  = Roles for user <user> (comma separated). Only valid for the ArgumentsRealm realm class\n   \n   --fileRealm.configFile         = File containing users/passwds/roles. Only valid for the FileRealm realm class\n   \nAccess logging:\n   --accessLoggerClassName        = Set the access logger class to use for user authentication. Defaults to disabled\n   --simpleAccessLogger.format    = The log format to use. Supports combined/common/resin/custom (SimpleAccessLogger only)\n   --simpleAccessLogger.file      = The location pattern for the log file(SimpleAccessLogger only)");
        mainMethod.invoke(null, new Object[]{arguments.toArray(new String[arguments.size()])});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File whoAmI() throws IOException {
        try {
            return Main.whoAmIFromJnlp();
        }
        catch (Exception x) {
            Main.getSystemErrorStream().println("INFO: ZipFile.name trick did not work (" + x.toString() + "), using fallback");
            File myself = File.createTempFile("javamelody", ".jar");
            myself.deleteOnExit();
            InputStream is = Main.class.getProtectionDomain().getCodeSource().getLocation().openStream();
            try {
                FileOutputStream os = new FileOutputStream(myself);
                try {
                    Main.copyStream(is, os);
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            finally {
                is.close();
            }
            return myself;
        }
    }

    private static PrintStream getSystemOutputStream() {
        return System.out;
    }

    private static PrintStream getSystemErrorStream() {
        return System.err;
    }

    private static File whoAmIFromJnlp() throws Exception {
        URL classFile = Main.class.getClassLoader().getResource("Main.class");
        JarFile jf = ((JarURLConnection)classFile.openConnection()).getJarFile();
        Field f = ZipFile.class.getDeclaredField("name");
        f.setAccessible(true);
        return new File((String)f.get(jf));
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractFromJar(String resource, String fileName, String suffix) throws IOException {
        File tmp;
        URL res = Main.class.getResource(resource);
        try {
            tmp = File.createTempFile(fileName, suffix);
        }
        catch (IOException e) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            throw new IllegalStateException("JavaMelody has failed to create a temporary file in " + tmpdir, e);
        }
        InputStream is = res.openStream();
        try {
            FileOutputStream os = new FileOutputStream(tmp);
            try {
                Main.copyStream(is, os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            is.close();
        }
        tmp.deleteOnExit();
        return tmp;
    }

    private static void deleteContents(File file) throws IOException {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File file2 : files) {
                Main.deleteContents(file2);
            }
        }
        Main.deleteFile(file);
    }

    private static boolean deleteFile(File file) {
        return file.delete();
    }
}

