/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jrobin.core.jrrd.Constants;

public class RRDFile
implements Constants {
    boolean bigEndian;
    int alignment;
    RandomAccessFile ras;
    byte[] buffer;

    RRDFile(String name) throws IOException {
        this(new File(name));
    }

    RRDFile(File file) throws IOException {
        this.ras = new RandomAccessFile(file, "r");
        this.buffer = new byte[128];
        this.initDataLayout(file);
    }

    private void initDataLayout(File file) throws IOException {
        if (file.exists()) {
            this.ras.read(this.buffer, 0, 24);
            int index = this.indexOf(FLOAT_COOKIE_BIG_ENDIAN, this.buffer);
            if (index != -1) {
                this.bigEndian = true;
            } else {
                index = this.indexOf(FLOAT_COOKIE_LITTLE_ENDIAN, this.buffer);
                if (index != -1) {
                    this.bigEndian = false;
                } else {
                    throw new IOException("Invalid RRD file");
                }
            }
            switch (index) {
                case 12: {
                    this.alignment = 4;
                    break;
                }
                case 16: {
                    this.alignment = 8;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported architecture");
                }
            }
        }
        this.ras.seek(0L);
    }

    private int indexOf(byte[] pattern, byte[] array) {
        return new String(array).indexOf(new String(pattern));
    }

    boolean isBigEndian() {
        return this.bigEndian;
    }

    int getAlignment() {
        return this.alignment;
    }

    double readDouble() throws IOException {
        byte[] tx = new byte[8];
        this.ras.read(this.buffer, 0, 8);
        if (this.bigEndian) {
            tx = this.buffer;
        } else {
            int i = 0;
            while (i < 8) {
                tx[7 - i] = this.buffer[i];
                ++i;
            }
        }
        DataInputStream reverseDis = new DataInputStream(new ByteArrayInputStream(tx));
        return reverseDis.readDouble();
    }

    int readInt() throws IOException {
        return this.readInt(false);
    }

    int readInt(boolean dump) throws IOException {
        this.ras.read(this.buffer, 0, 4);
        int value = this.bigEndian ? 0xFF & this.buffer[3] | (0xFF & this.buffer[2]) << 8 | (0xFF & this.buffer[1]) << 16 | (0xFF & this.buffer[0]) << 24 : 0xFF & this.buffer[0] | (0xFF & this.buffer[1]) << 8 | (0xFF & this.buffer[2]) << 16 | (0xFF & this.buffer[3]) << 24;
        return value;
    }

    String readString(int maxLength) throws IOException {
        this.ras.read(this.buffer, 0, maxLength);
        return new String(this.buffer, 0, maxLength).trim();
    }

    void skipBytes(int n) throws IOException {
        this.ras.skipBytes(n);
    }

    int align(int boundary) throws IOException {
        int skip = (int)((long)boundary - this.ras.getFilePointer() % (long)boundary) % boundary;
        if (skip != 0) {
            this.ras.skipBytes(skip);
        }
        return skip;
    }

    int align() throws IOException {
        return this.align(this.alignment);
    }

    long info() throws IOException {
        return this.ras.getFilePointer();
    }

    long getFilePointer() throws IOException {
        return this.ras.getFilePointer();
    }

    void close() throws IOException {
        this.ras.close();
    }
}

