/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import net.bull.javamelody.LoggingHandler;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class Log4J2Appender
extends AbstractAppender {
    private static final long serialVersionUID = 1L;
    private static final String MESSAGE_PATTERN = "%-5p [%c] %m%n";
    private static final Level THRESHOLD = Level.WARN;
    private static final String APPENDER_NAME = Log4J2Appender.class.getName();
    private static final PatternLayout LAYOUT = PatternLayout.createLayout((String)"%-5p [%c] %m%n", null, null, null, null, (boolean)true, (boolean)true, null, null);
    private static final ThresholdFilter FILTER = ThresholdFilter.createFilter((Level)THRESHOLD, null, null);
    private static final Log4J2Appender SINGLETON = new Log4J2Appender();

    public Log4J2Appender() {
        this(APPENDER_NAME, (Filter)FILTER, (Layout<? extends Serializable>)LAYOUT);
    }

    public Log4J2Appender(String name, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, layout, true);
    }

    static Log4J2Appender getSingleton() {
        return SINGLETON;
    }

    void register() {
        LoggerContext ctx;
        if (LogManager.getContext((boolean)false) instanceof LoggerContext && (ctx = (LoggerContext)LogManager.getContext((boolean)false)).getConfiguration() instanceof AbstractConfiguration) {
            AbstractConfiguration config = (AbstractConfiguration)ctx.getConfiguration();
            Log4J2Appender appender = Log4J2Appender.getSingleton();
            appender.start();
            config.addAppender((Appender)appender);
            Logger rootLogger = LogManager.getRootLogger();
            LoggerConfig loggerConfig = config.getLoggerConfig(rootLogger.getName());
            loggerConfig.addAppender((Appender)appender, null, null);
            ctx.updateLoggers();
        }
    }

    void deregister() {
        LoggerContext ctx;
        if (LogManager.getContext((boolean)false) instanceof LoggerContext && (ctx = (LoggerContext)LogManager.getContext((boolean)false)).getConfiguration() instanceof AbstractConfiguration) {
            AbstractConfiguration config = (AbstractConfiguration)ctx.getConfiguration();
            Log4J2Appender appender = Log4J2Appender.getSingleton();
            appender.stop();
            config.removeAppender(appender.getName());
            Logger rootLogger = LogManager.getRootLogger();
            LoggerConfig loggerConfig = config.getLoggerConfig(rootLogger.getName());
            loggerConfig.removeAppender(appender.getName());
            ctx.updateLoggers();
        }
    }

    public void append(LogEvent event) {
        Throwable throwable = event.getThrown();
        String message = this.getLayout().toSerializable(event).toString();
        LoggingHandler.addErrorLogToCounter(message, throwable);
    }
}

