/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.javamelody;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.extensions.client.MenuItem;
import com.google.gerrit.extensions.webui.TopMenu;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.CapabilityControl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;

public class MonitoringTopMenu
implements TopMenu {
    private final List<TopMenu.MenuEntry> menuEntries;
    private final Provider<CurrentUser> userProvider;
    private final String pluginName;

    @Inject
    public MonitoringTopMenu(Provider<CurrentUser> userProvider, @PluginName String pluginName) {
        this.userProvider = userProvider;
        this.pluginName = pluginName;
        this.menuEntries = Lists.newArrayList();
        if (this.canMonitor()) {
            this.menuEntries.add(new TopMenu.MenuEntry("Monitoring", Collections.singletonList(new MenuItem("JavaMelody", "monitoring"))));
        }
    }

    public List<TopMenu.MenuEntry> getEntries() {
        return this.menuEntries;
    }

    private boolean canMonitor() {
        if (((CurrentUser)this.userProvider.get()).isIdentifiedUser()) {
            CapabilityControl ctl = ((CurrentUser)this.userProvider.get()).getCapabilities();
            return ctl.canAdministrateServer() || ctl.canPerform(String.format("%s-%s", this.pluginName, "monitoring"));
        }
        return false;
    }
}

