/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import net.bull.javamelody.LoggingHandler;
import org.slf4j.LoggerFactory;

public class LogbackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String MESSAGE_PATTERN = "%-5level %logger{36} - %msg%nopex%n";
    private static final String EXCEPTION_PATTERN = "%ex";
    private static final Level THRESHOLD = Level.WARN;
    private static final LogbackAppender SINGLETON = new LogbackAppender();
    private final PatternLayout exceptionLayout = new PatternLayout();
    private final PatternLayout messageLayout = new PatternLayout();

    public LogbackAppender() {
        LoggerContext lc = LogbackAppender.getDefaultContext();
        this.messageLayout.setContext((Context)lc);
        this.messageLayout.setPattern(MESSAGE_PATTERN);
        this.messageLayout.start();
        this.exceptionLayout.setContext((Context)lc);
        this.exceptionLayout.setPattern(EXCEPTION_PATTERN);
        this.exceptionLayout.start();
        this.setContext((Context)lc);
        this.start();
    }

    private static LoggerContext getDefaultContext() {
        return (LoggerContext)LoggerFactory.getILoggerFactory();
    }

    static LogbackAppender getSingleton() {
        return SINGLETON;
    }

    void register() {
        LogbackAppender.getDefaultContext().getLogger("ROOT").addAppender((Appender)this);
    }

    void deregister() {
        LogbackAppender.getDefaultContext().getLogger("ROOT").detachAppender((Appender)this);
    }

    protected void append(ILoggingEvent event) {
        if (event.getLevel().isGreaterOrEqual(THRESHOLD)) {
            String output = this.messageLayout.doLayout(event);
            String stackTrace = this.exceptionLayout.doLayout(event);
            if (stackTrace.length() == 0) {
                stackTrace = null;
            }
            LoggingHandler.addErrorLogToCounter(output, stackTrace);
        }
    }
}

