/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.List;
import net.bull.javamelody.PdfAbstractReport;
import net.bull.javamelody.PdfFonts;

abstract class PdfAbstractTableReport
extends PdfAbstractReport {
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private PdfPTable table;
    private boolean oddRow;

    PdfAbstractTableReport(Document document) {
        super(document);
    }

    void initTable(List<String> headers, int[] relativeWidths) throws DocumentException {
        assert (headers.size() == relativeWidths.length);
        PdfPTable mytable = new PdfPTable(headers.size());
        mytable.setWidthPercentage(100.0f);
        mytable.setWidths(relativeWidths);
        mytable.setHeaderRows(1);
        PdfPCell defaultCell = mytable.getDefaultCell();
        defaultCell.setGrayFill(0.9f);
        defaultCell.setHorizontalAlignment(1);
        defaultCell.setPaddingLeft(0.0f);
        defaultCell.setPaddingRight(0.0f);
        Font tableHeaderFont = PdfFonts.TABLE_HEADER.getFont();
        for (String header : headers) {
            mytable.addCell(new Phrase(header, tableHeaderFont));
        }
        defaultCell.setPaddingLeft(2.0f);
        defaultCell.setPaddingRight(2.0f);
        this.table = mytable;
    }

    void nextRow() {
        if (this.oddRow) {
            this.getDefaultCell().setGrayFill(0.97f);
        } else {
            this.getDefaultCell().setGrayFill(1.0f);
        }
        this.oddRow = !this.oddRow;
    }

    PdfPCell getDefaultCell() {
        return this.table.getDefaultCell();
    }

    void addCell(String string) {
        this.table.addCell(new Phrase(string, this.cellFont));
    }

    void addCell(Phrase phrase) {
        this.table.addCell(phrase);
    }

    void addCell(Image image) {
        this.table.addCell(image);
    }

    void addCell(PdfPCell cell) {
        this.table.addCell(cell);
    }

    boolean addTableToDocument() throws DocumentException {
        return this.addToDocument((Element)this.table);
    }
}

