/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.io.File;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.inspector.RrdNode;
import org.jrobin.inspector.Util;

class MainTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    private static final DefaultMutableTreeNode INVALID_NODE = new DefaultMutableTreeNode("No valid RRD file specified");

    MainTreeModel() {
        super(INVALID_NODE);
    }

    boolean setFile(File file) {
        try {
            RrdDb rrd = new RrdDb(file.getAbsolutePath(), true);
            try {
                DefaultMutableTreeNode root = new DefaultMutableTreeNode(new RrdNode(rrd));
                int dsCount = rrd.getRrdDef().getDsCount();
                int arcCount = rrd.getRrdDef().getArcCount();
                int dsIndex = 0;
                while (dsIndex < dsCount) {
                    DefaultMutableTreeNode dsNode = new DefaultMutableTreeNode(new RrdNode(rrd, dsIndex));
                    int arcIndex = 0;
                    while (arcIndex < arcCount) {
                        DefaultMutableTreeNode arcNode = new DefaultMutableTreeNode(new RrdNode(rrd, dsIndex, arcIndex));
                        dsNode.add(arcNode);
                        ++arcIndex;
                    }
                    root.add(dsNode);
                    ++dsIndex;
                }
                this.setRoot(root);
            }
            finally {
                rrd.close();
            }
        }
        catch (IOException e) {
            this.setRoot(INVALID_NODE);
            Util.error(null, e);
        }
        catch (RrdException e) {
            this.setRoot(INVALID_NODE);
            Util.error(null, e);
        }
        return false;
    }
}

