/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import net.bull.javamelody.Counter;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MonitoredWithGuice;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class MonitoringGuiceInterceptor
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = -6594338383847482623L;
    private static final Counter GUICE_COUNTER = MonitoringProxy.getGuiceCounter();
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(GUICE_COUNTER.getName());
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));

    public MonitoringGuiceInterceptor() {
        GUICE_COUNTER.setDisplayed(!COUNTER_HIDDEN);
        GUICE_COUNTER.setUsed(true);
        LOG.debug("guice interceptor initialized");
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (DISABLED || !GUICE_COUNTER.isDisplayed()) {
            return invocation.proceed();
        }
        String requestName = this.getRequestName(invocation);
        boolean systemError = false;
        try {
            GUICE_COUNTER.bindContextIncludingCpu(requestName);
            Object object = invocation.proceed();
            Object var6_6 = null;
            GUICE_COUNTER.addRequestForCurrentContext(systemError);
            return object;
        }
        catch (Error e) {
            try {
                systemError = true;
                throw e;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                GUICE_COUNTER.addRequestForCurrentContext(systemError);
                throw throwable;
            }
        }
    }

    protected String getRequestName(MethodInvocation invocation) {
        String classPart = MonitoringGuiceInterceptor.getClassPart(invocation);
        String methodPart = MonitoringGuiceInterceptor.getMethodPart(invocation);
        return classPart + '.' + methodPart;
    }

    private static String getClassPart(MethodInvocation invocation) {
        Class<?> targetClass = invocation.getMethod().getDeclaringClass();
        MonitoredWithGuice classAnnotation = targetClass.getAnnotation(MonitoredWithGuice.class);
        if (classAnnotation == null || classAnnotation.name() == null || classAnnotation.name().length() == 0) {
            return targetClass.getSimpleName();
        }
        return classAnnotation.name();
    }

    private static String getMethodPart(MethodInvocation invocation) {
        MonitoredWithGuice methodAnnotation = invocation.getMethod().getAnnotation(MonitoredWithGuice.class);
        if (methodAnnotation == null || methodAnnotation.name() == null || methodAnnotation.name().length() == 0) {
            return invocation.getMethod().getName();
        }
        return methodAnnotation.name();
    }
}

