Database-Monitoring
===================

This feature is experimental and is not supported out of the box for Gerrit
monitoring on Jetty.

Background: JavaMelody only supports JNDI DataSource in Web container (Tomcat).
Because Gerrit instantiates its data source on its own, JavaMelody can not
intercept it and therefore no SQL statistic reports can be gathered.

To overcome that problem a data source proxy must be installed. Because the
instantiation of the data source takes place in Gerrit core, it must be patched.

Next problem: JavaMelody JARs (that creates the data source proxies) must be
available in the bootstrap classpath for Gerrit core to load it.

Last problem: we shouldn't package the plugin dependencies inside the
plugin itself (shaded jar in Maven jargon) and in $gerrit_site/lib. We would
need to strip it from the plugin.

Cherry-pick this change and compile Gerrit:

https://gerrit-review.googlesource.com/#/c/52747

Add the following target to BUCK in javamelody plugin:

```
gerrit_plugin(
  name = 'javamelody-no-deps',
  srcs = glob(['src/main/java/**/*.java']),
  resources = glob(['src/main/resources/**/*']),
  manifest_entries = [
    'Gerrit-PluginName: javamelody',
    'Gerrit-Module: com.googlesource.gerrit.plugins.javamelody.Module',
    'Gerrit-HttpModule: com.googlesource.gerrit.plugins.javamelody.HttpModule',
  ],
  compile_deps = [
    '//plugins/javamelody/lib:javamelody',
    '//plugins/javamelody/lib:jrobin',
  ],
)
```

Compile the plugin without dependencies:

```
buck build plugins/javamelody:javamelody-no-deps
```

Copy the dependencies manually to $gerrit_site/libs:

```
cp
~/.gerritcodereview/buck-cache/jrobin-1.5.9.jar-bd9a84484c67de930fa841f23cd6a93108b05cd0
$gerrit_site/lib/jrobin.jar
cp
~/.gerritcodereview/buck-cache/javamelody-core-1.48.0.jar-4c573306061019430a735d9d58f93639f4a0ff0b
$gerrit_site/lib/javamelody.jar

```

Deploy plugin without dependencies:

```
cp buck-out/gen/plugins/javamelody/javamelody-no-deps.jar $gerrit_site/plugins
```

Run Gerrit@Jetty and enjoy SQL statistics, a lá:

http://i.imgur.com/8EyAA9u.png
