/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import monasca.api.ApiConfig;
import monasca.common.model.metric.Metric;
import monasca.common.model.metric.MetricEnvelope;
import monasca.common.model.metric.MetricEnvelopes;

public class MetricService {
    private final ApiConfig config;
    private final Producer<String, String> producer;
    private final Meter metricMeter;
    private final Meter batchMeter;

    @Inject
    public MetricService(ApiConfig config, Producer<String, String> producer, MetricRegistry metricRegistry) {
        this.config = config;
        this.producer = producer;
        this.metricMeter = metricRegistry.meter(MetricRegistry.name(MetricService.class, (String[])new String[]{"metrics.published"}));
        this.batchMeter = metricRegistry.meter(MetricRegistry.name(MetricService.class, (String[])new String[]{"batches.published"}));
    }

    public void create(List<Metric> metrics, String tenantId, @Nullable String crossTenantId) {
        String metricTenantId = Strings.isNullOrEmpty((String)crossTenantId) ? tenantId : crossTenantId;
        ImmutableMap.Builder metaBuilder = new ImmutableMap.Builder().put((Object)"tenantId", (Object)metricTenantId).put((Object)"region", (Object)this.config.region);
        ImmutableMap meta = metaBuilder.build();
        ArrayList<KeyedMessage> keyedMessages = new ArrayList<KeyedMessage>(metrics.size());
        for (Metric metric : metrics) {
            MetricEnvelope envelope = new MetricEnvelope(metric, (Map)meta);
            keyedMessages.add(new KeyedMessage(this.config.metricsTopic, (Object)this.buildKey(metricTenantId, metric), (Object)MetricEnvelopes.toJson((MetricEnvelope)envelope)));
            this.metricMeter.mark();
        }
        this.producer.send(keyedMessages);
        this.batchMeter.mark();
    }

    private String buildKey(String metricTenantId, Metric metric) {
        StringBuilder key = new StringBuilder(metricTenantId);
        key.append(metric.name);
        if (metric.dimensions != null && !metric.dimensions.isEmpty()) {
            for (Map.Entry<String, String> dim : this.buildSortedDimSet(metric.dimensions)) {
                key.append(dim.getKey());
                key.append(dim.getValue());
            }
        }
        String keyValue = key.toString();
        return keyValue;
    }

    private List<Map.Entry<String, String>> buildSortedDimSet(Map<String, String> dimMap) {
        ArrayList<Map.Entry<String, String>> dims = new ArrayList<Map.Entry<String, String>>(dimMap.entrySet());
        Collections.sort(dims, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                int nameCmp = o1.getKey().compareTo(o2.getKey());
                return nameCmp != 0 ? nameCmp : o1.getValue().compareTo(o2.getValue());
            }
        });
        return dims;
    }
}

