/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app.validation;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import monasca.api.resource.exception.Exceptions;
import monasca.common.model.Services;

public final class DimensionValidation {
    private static final Map<String, DimensionValidator> VALIDATORS;
    private static final Pattern UUID_PATTERN;
    private static final Pattern VALID_DIMENSION_NAME;
    private static final String INVALID_CHAR_STRING = "> < = { } ( ) ' \" , ; &";

    private DimensionValidation() {
    }

    public static Map<String, String> normalize(Map<String, String> dimensions) {
        if (dimensions == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> dimension : dimensions.entrySet()) {
            String dimensionKey = null;
            if (dimension.getKey() != null && (dimensionKey = CharMatcher.WHITESPACE.trimFrom((CharSequence)dimension.getKey())).isEmpty()) {
                dimensionKey = null;
            }
            String dimensionValue = null;
            if (dimension.getValue() != null && (dimensionValue = CharMatcher.WHITESPACE.trimFrom((CharSequence)dimension.getValue())).isEmpty()) {
                dimensionValue = null;
            }
            result.put(dimensionKey, dimensionValue);
        }
        return result;
    }

    public static void validate(Map<String, String> dimensions, @Nullable String service) {
        for (Map.Entry<String, String> dimension : dimensions.entrySet()) {
            String name = dimension.getKey();
            String value = dimension.getValue();
            if (Strings.isNullOrEmpty((String)name)) {
                throw Exceptions.unprocessableEntity("Dimension name cannot be empty", new Object[0]);
            }
            if (Strings.isNullOrEmpty((String)value)) {
                throw Exceptions.unprocessableEntity("Dimension %s cannot have an empty value", name);
            }
            if (name.length() > 255) {
                throw Exceptions.unprocessableEntity("Dimension name %s must be 255 characters or less", name);
            }
            if (value.length() > 255) {
                throw Exceptions.unprocessableEntity("Dimension value %s must be 255 characters or less", value);
            }
            if (name.startsWith("_")) {
                throw Exceptions.unprocessableEntity("Dimension name cannot start with underscore (_)", name);
            }
            if (!VALID_DIMENSION_NAME.matcher(name).matches()) {
                throw Exceptions.unprocessableEntity("Dimension name %s may not contain: %s", name, INVALID_CHAR_STRING);
            }
            if (service == null) continue;
            if (!name.equals("service") && !Services.isValidDimensionName((String)service, (String)name)) {
                throw Exceptions.unprocessableEntity("%s is not a valid dimension name for service %s", name, service);
            }
            DimensionValidator validator = VALIDATORS.get(service);
            if (validator == null || validator.isValidDimension(name, value)) continue;
            throw Exceptions.unprocessableEntity("%s is not a valid dimension value for service %s", value, service);
        }
    }

    public static void validateNames(List<String> names) {
        if (names != null) {
            for (String name : names) {
                if (Strings.isNullOrEmpty((String)name)) {
                    throw Exceptions.unprocessableEntity("Dimension name cannot be empty", new Object[0]);
                }
                if (name.length() > 255) {
                    throw Exceptions.unprocessableEntity("Dimension name '%s' must be 255 characters or less", name);
                }
                if (name.startsWith("_")) {
                    throw Exceptions.unprocessableEntity("Dimension name '%s' cannot start with underscore (_)", name);
                }
                if (VALID_DIMENSION_NAME.matcher(name).matches()) continue;
                throw Exceptions.unprocessableEntity("Dimension name '%s' may not contain: %s", name, INVALID_CHAR_STRING);
            }
        }
    }

    static {
        UUID_PATTERN = Pattern.compile("\\w{8}-\\w{4}-\\w{4}-\\w{4}-\\w{12}");
        VALID_DIMENSION_NAME = Pattern.compile("[^><={}(), '\";&]+$");
        VALIDATORS = new HashMap<String, DimensionValidator>();
        VALIDATORS.put("hpcs.compute", new DimensionValidator(){

            @Override
            public boolean isValidDimension(String name, String value) {
                if ("instance_id".equals(name)) {
                    return value.length() != 36 || UUID_PATTERN.matcher(value).matches();
                }
                if ("az".equals(name)) {
                    return Ints.tryParse((String)value) != null;
                }
                return true;
            }
        });
        VALIDATORS.put("hpcs.object-store", new DimensionValidator(){

            @Override
            public boolean isValidDimension(String name, String value) {
                if ("container".equals(name)) {
                    return value.length() < 256 || !value.contains("/");
                }
                return true;
            }
        });
        VALIDATORS.put("hpcs.volume", new DimensionValidator(){

            @Override
            public boolean isValidDimension(String name, String value) {
                if ("instance_id".equals(name)) {
                    return value.length() != 36 || UUID_PATTERN.matcher(value).matches();
                }
                if ("az".equals(name)) {
                    return Ints.tryParse((String)value) != null;
                }
                return true;
            }
        });
    }

    static interface DimensionValidator {
        public boolean isValidDimension(String var1, String var2);
    }
}

