/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app.validation;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import monasca.api.resource.exception.Exceptions;
import monasca.common.model.Services;

public class MetricNameValidation {
    private static final Pattern VALID_METRIC_NAME = Pattern.compile("[^><={}(), '\";&]+$");

    private MetricNameValidation() {
    }

    public static String normalize(String metricName) {
        return metricName == null ? null : CharMatcher.WHITESPACE.trimFrom((CharSequence)metricName);
    }

    public static void validate(String metricName, @Nullable String service, boolean nameRequiredFlag) {
        if (Strings.isNullOrEmpty((String)metricName)) {
            if (nameRequiredFlag) {
                throw Exceptions.unprocessableEntity("Metric name is required", new Object[0]);
            }
            return;
        }
        if (metricName.length() > 255) {
            throw Exceptions.unprocessableEntity("Metric name %s must be %d characters or less", metricName, 255);
        }
        if (!Services.isReserved((String)metricName) && !VALID_METRIC_NAME.matcher(metricName).matches()) {
            throw Exceptions.unprocessableEntity("Metric name %s may not contain: > < = { } ( ) ' \" , ; &", metricName);
        }
        if (service != null && Services.isReserved((String)service) && !Strings.isNullOrEmpty((String)metricName) && !Services.isValidMetricName((String)service, (String)metricName)) {
            throw Exceptions.unprocessableEntity("%s is not a valid metric name for namespace %s", metricName, service);
        }
    }
}

