/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence;

import com.google.inject.Inject;
import monasca.api.ApiConfig;

public class PersistUtils {
    private final int maxQueryLimit;
    private final int DEFAULT_MAX_QUERY_LIMIT = 10000;

    @Inject
    public PersistUtils(ApiConfig config) {
        this.maxQueryLimit = config.maxQueryLimit;
    }

    public PersistUtils(int maxQueryLimit) {
        this.maxQueryLimit = maxQueryLimit;
    }

    public PersistUtils() {
        this.maxQueryLimit = 10000;
    }

    public int getLimit(String limit) {
        int limitInt;
        if (limit == null || limit.isEmpty()) {
            return this.maxQueryLimit;
        }
        try {
            limitInt = Integer.parseInt(limit);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Found invalid Limit: '%1$s'. Limit must be an integer.", limit));
        }
        if (limitInt <= this.maxQueryLimit) {
            return limitInt;
        }
        return this.maxQueryLimit;
    }
}

