/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.influxdb;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import monasca.api.infrastructure.persistence.PersistUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class InfluxV9Utils {
    private final PersistUtils persistUtils;
    private static final Pattern sqlUnsafePattern = Pattern.compile("^.*('|;|\")+.*$");

    @Inject
    public InfluxV9Utils(PersistUtils persistUtils) {
        this.persistUtils = persistUtils;
    }

    public String sanitize(String taintedString) throws Exception {
        Matcher m = sqlUnsafePattern.matcher(taintedString);
        if (m.matches()) {
            throw new Exception(String.format("Input from user contains single quote ['] or semi-colon [;] or double quote [\"] characters[ %1$s ]", taintedString));
        }
        return taintedString;
    }

    String buildTimePart(DateTime startTime, DateTime endTime) {
        StringBuilder sb = new StringBuilder();
        if (startTime != null) {
            sb.append(String.format(" and time > %1$ds", startTime.getMillis() / 1000L));
        }
        if (endTime != null) {
            sb.append(String.format(" and time < %1$ds", endTime.getMillis() / 1000L));
        }
        return sb.toString();
    }

    public String buildAlarmsPart(List<String> alarmIds) {
        StringBuilder sb = new StringBuilder();
        for (String alarmId : alarmIds) {
            if (sb.length() > 0) {
                sb.append(" or ");
            }
            sb.append(String.format(" alarm_id = '%1$s' ", alarmId));
        }
        if (sb.length() > 0) {
            sb.insert(0, " and (");
            sb.insert(sb.length(), ")");
        }
        return sb.toString();
    }

    public String groupByPart() {
        return " group by *";
    }

    public String namePart(String name, boolean isRequired) throws Exception {
        if (isRequired && (name == null || name.isEmpty())) {
            throw new Exception(String.format("Found null or empty name: %1$s", name));
        }
        if (name == null || name.isEmpty()) {
            return "";
        }
        return String.format(" from \"%1$s\"", this.sanitize(name));
    }

    public String publicTenantIdPart(String tenantId) throws Exception {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new Exception(String.format("Found null or empty tenant id: %1$s", tenantId));
        }
        return " tenant_id='" + this.sanitize(tenantId) + "'";
    }

    public String privateTenantIdPart(String tenantId) throws Exception {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new Exception(String.format("Found null or empty tenant id: %1$s", tenantId));
        }
        return " _tenant_id='" + this.sanitize(tenantId) + "'";
    }

    public String alarmIdPart(String alarmId) {
        if (alarmId == null || alarmId.isEmpty()) {
            return "";
        }
        return " and alarm_id='" + alarmId + "'";
    }

    public String timeOffsetPart(String offset) {
        if (offset == null || offset.isEmpty()) {
            return "";
        }
        return String.format(" and time > '%1$s'", offset);
    }

    public String privateRegionPart(String region) throws Exception {
        if (region == null || region.isEmpty()) {
            throw new Exception(String.format("Found null or empty region: %1$s", region));
        }
        return " and _region='" + this.sanitize(region) + "'";
    }

    public String dimPart(Map<String, String> dims) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (dims != null && !dims.isEmpty()) {
            for (String k : dims.keySet()) {
                String v = dims.get(k);
                if (k == null || k.isEmpty() || v == null || v.isEmpty()) continue;
                sb.append(" and " + this.sanitize(k) + "=" + "'" + this.sanitize(v) + "'");
            }
        }
        return sb.toString();
    }

    public String startTimePart(DateTime startTime) {
        return startTime != null ? " and time > '" + ISODateTimeFormat.dateTime().print((ReadableInstant)startTime) + "'" : "";
    }

    public String endTimePart(DateTime endTime) {
        return endTime != null ? " and time < '" + ISODateTimeFormat.dateTime().print((ReadableInstant)endTime) + "'" : "";
    }

    public String limitPart(int limit) {
        return String.format(" limit %1$d", limit + 1);
    }

    public String offsetPart(int startIndex) {
        return String.format(" offset %1$d", startIndex);
    }

    public int startIndex(String offset) {
        if (offset == null || offset.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(offset) + 1;
    }

    public String startTimeEndTimePart(DateTime startTime, DateTime endTime) {
        return this.buildTimePart(startTime, endTime);
    }

    public String alarmIdsPart(List<String> alarmIdList) {
        return this.buildAlarmsPart(alarmIdList);
    }

    public String periodPartWithGroupBy(int period) {
        return period > 0 ? String.format(" group by time(%1$ds), * fill(0)", period) : " group by time(300s), * fill(0)";
    }

    public String periodPart(int period) {
        return period > 0 ? String.format(" group by time(%1$ds) fill(0)", period) : " group by time(300s) fill(0)";
    }

    Map<String, String> filterPrivateTags(Map<String, String> tagMap) {
        HashMap<String, String> filteredMap = new HashMap<String, String>(tagMap);
        filteredMap.remove("_tenant_id");
        filteredMap.remove("_region");
        return filteredMap;
    }
}

